/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.SimpleNode;

public class ASTList
extends SimpleNode {
    private static final long serialVersionUID = 6045178972189002055L;
    protected Object[] values;

    ASTList(int id) {
        super(id);
    }

    public ASTList() {
        super(20);
    }

    public ASTList(Object[] objects) {
        super(20);
        this.setValues(objects);
    }

    public ASTList(Collection<?> objects) {
        super(20);
        this.setValues(objects);
    }

    public ASTList(Iterator<?> objects) {
        super(20);
        this.setValues(objects);
    }

    @Override
    public Expression shallowCopy() {
        return new ASTList(this.id);
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        return this.values;
    }

    @Override
    public int getType() {
        return 28;
    }

    @Override
    protected String getExpressionOperator(int index) {
        return ",";
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        out.append('(');
        if (this.values != null && this.values.length > 0) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    out.append(this.getExpressionOperator(i));
                    out.append(' ');
                }
                if (this.values[i] instanceof Expression) {
                    ((Expression)this.values[i]).appendAsString(out);
                    continue;
                }
                ASTList.appendScalarAsString(out, this.values[i], '\"');
            }
        }
        out.append(')');
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        if (this.parent != null) {
            out.append("(");
        }
        if (this.values != null && this.values.length > 0) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    out.append(this.getEJBQLExpressionOperator(i));
                    out.append(' ');
                }
                if (this.values[i] == null) {
                    out.append("null");
                    continue;
                }
                SimpleNode.encodeScalarAsEJBQL(parameterAccumulator, out, this.values[i]);
            }
        }
        if (this.parent != null) {
            out.append(')');
        }
    }

    @Override
    public int getOperandCount() {
        return 1;
    }

    @Override
    public Object getOperand(int index) {
        if (index == 0) {
            return this.values;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public void setOperand(int index, Object value) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.setValues(value);
    }

    protected void setValues(Object value) {
        if (value == null) {
            this.values = null;
        } else if (value instanceof Object[]) {
            int size = ((Object[])value).length;
            this.values = new Object[size];
            System.arraycopy((Object[])value, 0, this.values, 0, size);
        } else if (value instanceof Collection) {
            Collection c = (Collection)value;
            this.values = c.toArray(new Object[c.size()]);
        } else if (value instanceof Iterator) {
            ArrayList values = new ArrayList();
            Iterator it = (Iterator)value;
            while (it.hasNext()) {
                values.add(it.next());
            }
            this.values = values.toArray();
        } else {
            throw new IllegalArgumentException("Invalid value class '" + value.getClass().getName() + "', expected null, Object[], Collection, Iterator");
        }
        this.convertValues();
    }

    private void convertValues() {
        for (int i = 0; i < this.values.length; ++i) {
            if (!(this.values[i] instanceof Persistent)) continue;
            this.values[i] = ((Persistent)this.values[i]).getObjectId();
        }
    }

    @Override
    public void jjtClose() {
        super.jjtClose();
        int size = this.jjtGetNumChildren();
        Object[] listValue = new Object[size];
        for (int i = 0; i < size; ++i) {
            listValue[i] = this.unwrapChild(this.jjtGetChild(i));
        }
        this.setValues(listValue);
        this.children = null;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }
}

