/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.TrimmingQualifierTranslator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTExtract;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.map.DbAttribute;

class SQLServerTrimmingQualifierTranslator
extends TrimmingQualifierTranslator {
    private List<Expression> expressionStack = new ArrayList<Expression>();

    SQLServerTrimmingQualifierTranslator(QueryAssembler queryAssembler, String trimFunction) {
        super(queryAssembler, trimFunction);
    }

    @Override
    public void startNode(Expression node, Expression parentNode) {
        this.push(node);
        super.startNode(node, parentNode);
    }

    @Override
    protected void processColumn(DbAttribute dbAttr) {
        boolean likeCI;
        Expression node = this.peek(1);
        boolean bl = likeCI = node != null && dbAttr.getType() == 2005 && (node.getType() == 12 || node.getType() == 38);
        if (likeCI) {
            this.out.append("CAST(");
        }
        super.processColumn(dbAttr);
        if (likeCI) {
            this.out.append(" AS NVARCHAR(MAX))");
        }
    }

    @Override
    protected void processColumnWithQuoteSqlIdentifiers(DbAttribute dbAttr, Expression pathExp) {
        boolean likeCI;
        Expression node = this.peek(1);
        boolean bl = likeCI = node != null && dbAttr.getType() == 2005 && (node.getType() == 12 || node.getType() == 38);
        if (likeCI) {
            this.out.append("CAST(");
        }
        super.processColumnWithQuoteSqlIdentifiers(dbAttr, node);
        if (likeCI) {
            this.out.append(" AS NVARCHAR(MAX))");
        }
    }

    @Override
    public void endNode(Expression node, Expression parentNode) {
        super.endNode(node, parentNode);
        this.pop();
    }

    private void push(Expression node) {
        this.expressionStack.add(node);
    }

    private void pop() {
        int len = this.expressionStack.size();
        if (len > 0) {
            this.expressionStack.remove(len - 1);
        }
    }

    private Expression peek(int tailIndex) {
        int index = this.expressionStack.size() - tailIndex - 1;
        if (index < 0) {
            return null;
        }
        return this.expressionStack.get(index);
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "LENGTH": {
                this.out.append("LEN");
                break;
            }
            case "LOCATE": {
                this.out.append("CHARINDEX");
                break;
            }
            case "MOD": {
                break;
            }
            case "TRIM": {
                this.out.append("LTRIM(RTRIM");
                break;
            }
            case "CURRENT_DATE": {
                this.out.append("{fn CURDATE()}");
                break;
            }
            case "CURRENT_TIME": {
                this.out.append("{fn CURTIME()}");
                break;
            }
            default: {
                super.appendFunction(functionExpression);
            }
        }
    }

    @Override
    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("MOD".equals(functionExpression.getFunctionName())) {
            this.out.append(" % ");
        } else {
            super.appendFunctionArgDivider(functionExpression);
        }
    }

    @Override
    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("MOD".equals(functionExpression.getFunctionName())) {
            this.out.delete(this.out.length() - " % ".length(), this.out.length());
        } else {
            super.clearLastFunctionArgDivider(functionExpression);
            if ("TRIM".equals(functionExpression.getFunctionName())) {
                this.out.append(")");
            }
        }
        if (functionExpression instanceof ASTExtract) {
            this.out.append(")");
        }
    }

    @Override
    protected boolean parenthesisNeeded(Expression node, Expression parentNode) {
        if (node.getType() == 45 && node instanceof ASTExtract) {
            return false;
        }
        return super.parenthesisNeeded(node, parentNode);
    }

    @Override
    protected void appendExtractFunction(ASTExtract functionExpression) {
        this.out.append("DATEPART(");
        switch (functionExpression.getPart()) {
            case DAY_OF_MONTH: {
                this.out.append("DAY");
                break;
            }
            case DAY_OF_WEEK: {
                this.out.append("WEEKDAY");
                break;
            }
            case DAY_OF_YEAR: {
                this.out.append("DAYOFYEAR");
                break;
            }
            default: {
                this.out.append(functionExpression.getPart().name());
            }
        }
        this.out.append(" , ");
    }
}

