/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CopyCallbackMethodAction;
import org.apache.cayenne.modeler.action.CreateCallbackMethodAction;
import org.apache.cayenne.modeler.action.CutCallbackMethodAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodAction;
import org.apache.cayenne.modeler.editor.CallbackDescriptorTableModel;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.editor.ObjCallbackMethod;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.event.CallbackMethodListener;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCallbackMethodsTab
extends JPanel {
    private static Logger logger = LoggerFactory.getLogger(AbstractCallbackMethodsTab.class);
    ProjectController mediator;
    protected JToolBar toolBar;
    protected JPanel auxPanel;
    protected TableColumnPreferences tablePreferences;
    protected CallbackType[] callbackTypes = new CallbackType[]{new CallbackType(LifecycleEvent.POST_ADD), new CallbackType(LifecycleEvent.PRE_PERSIST), new CallbackType(LifecycleEvent.POST_PERSIST), new CallbackType(LifecycleEvent.PRE_UPDATE), new CallbackType(LifecycleEvent.POST_UPDATE), new CallbackType(LifecycleEvent.PRE_REMOVE), new CallbackType(LifecycleEvent.POST_REMOVE), new CallbackType(LifecycleEvent.POST_LOAD)};
    protected CayenneTable[] tables = new CayenneTable[this.callbackTypes.length];
    protected JPopupMenu popupMenu;

    public AbstractCallbackMethodsTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initController();
    }

    protected abstract CallbackMap getCallbackMap();

    protected CayenneAction getCreateCallbackMethodAction() {
        Application app = Application.getInstance();
        return app.getActionManager().getAction(CreateCallbackMethodAction.class);
    }

    protected RemoveCallbackMethodAction getRemoveCallbackMethodAction() {
        Application app = Application.getInstance();
        return app.getActionManager().getAction(RemoveCallbackMethodAction.class);
    }

    protected CopyCallbackMethodAction getCopyCallbackMethodAction() {
        Application app = Application.getInstance();
        return app.getActionManager().getAction(CopyCallbackMethodAction.class);
    }

    protected CutCallbackMethodAction getCutCallbackMethodAction() {
        Application app = Application.getInstance();
        return app.getActionManager().getAction(CutCallbackMethodAction.class);
    }

    protected PasteAction getPasteCallbackMethodAction() {
        Application app = Application.getInstance();
        return app.getActionManager().getAction(PasteAction.class);
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.add(this.getRemoveCallbackMethodAction().buildButton());
        this.toolBar.addSeparator(new Dimension(10, 0));
        this.toolBar.add(this.getCopyCallbackMethodAction().buildButton(1));
        this.toolBar.add(this.getCutCallbackMethodAction().buildButton(2));
        this.toolBar.add(this.getPasteCallbackMethodAction().buildButton(3));
        this.add((Component)this.toolBar, "North");
        this.auxPanel = new JPanel();
        this.auxPanel.setOpaque(false);
        this.auxPanel.setLayout(new BorderLayout());
        this.popupMenu = this.createPopup();
        this.createTables();
        this.add((Component)new JScrollPane(this.auxPanel), "Center");
    }

    protected abstract void initTablePreferences();

    protected void initController() {
        this.mediator.addCallbackMethodListener(new CallbackMethodListener(){

            @Override
            public void callbackMethodChanged(CallbackMethodEvent e) {
                AbstractCallbackMethodsTab.this.rebuildTables();
            }

            @Override
            public void callbackMethodAdded(CallbackMethodEvent e) {
                AbstractCallbackMethodsTab.this.rebuildTables();
                AbstractCallbackMethodsTab.this.selectAdded();
            }

            @Override
            public void callbackMethodRemoved(CallbackMethodEvent e) {
                int i;
                int row = -1;
                for (i = 0; i < AbstractCallbackMethodsTab.this.callbackTypes.length; ++i) {
                    if (AbstractCallbackMethodsTab.this.callbackTypes[i] != AbstractCallbackMethodsTab.this.getSelectedCallbackType()) continue;
                    row = AbstractCallbackMethodsTab.this.tables[i].getSelectedRow();
                    break;
                }
                AbstractCallbackMethodsTab.this.rebuildTables();
                if (row == AbstractCallbackMethodsTab.this.tables[i].getRowCount()) {
                    --row;
                }
                if (row < 0) {
                    return;
                }
                AbstractCallbackMethodsTab.this.tables[i].changeSelection(row, 0, false, false);
            }
        });
        for (CayenneTable table : this.tables) {
            this.mediator.getApplication().getActionManager().setupCutCopyPaste(table, CutCallbackMethodAction.class, CopyCallbackMethodAction.class);
        }
    }

    protected void rebuildTables() {
        CallbackMap callbackMap = this.getCallbackMap();
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            CallbackType callbackType = this.callbackTypes[i];
            ArrayList<String> methods = new ArrayList<String>();
            CallbackDescriptor descriptor = null;
            if (callbackMap != null && callbackType != null) {
                descriptor = callbackMap.getCallbackDescriptor(callbackType.getType());
                methods.addAll(descriptor.getCallbackMethods());
            }
            CallbackDescriptorTableModel model = new CallbackDescriptorTableModel(this.mediator, this, methods, descriptor, callbackType);
            this.tables[i].setModel(model);
        }
        for (CayenneTable table : this.tables) {
            this.tablePreferences.bind(table, null, null, null);
        }
    }

    private void createTables() {
        FormLayout formLayout = new FormLayout("left:pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(formLayout);
        int index = 0;
        for (CallbackType callbackType : this.callbackTypes) {
            this.tables[index] = this.createTable(callbackType);
            builder.append(this.createTablePanel(this.tables[index++]));
        }
        this.initTablePreferences();
        this.auxPanel.add((Component)builder.getPanel(), "Center");
        this.validate();
    }

    private CayenneTable createTable(CallbackType callbackType) {
        CayenneTable cayenneTable = new CayenneTable();
        cayenneTable.setDragEnabled(true);
        cayenneTable.setSortable(false);
        cayenneTable.setRowHeight(25);
        cayenneTable.setRowMargin(3);
        cayenneTable.setSelectionMode(2);
        cayenneTable.setAutoResizeMode(0);
        cayenneTable.setTransferHandler(new CallbackImportableHandler(cayenneTable));
        cayenneTable.getSelectionModel().addListSelectionListener(new CallbackListSelectionListener(cayenneTable));
        cayenneTable.getColumnModel().addColumnModelListener(new CallbackTableColumnModelListener(cayenneTable));
        cayenneTable.getTableHeader().addMouseListener(new CallbackMouseAdapter(cayenneTable));
        cayenneTable.getTableHeader().addMouseMotionListener(new CallbackMouseMotionListener(cayenneTable));
        TablePopupHandler.install(cayenneTable, this.popupMenu);
        this.addButtonAtHeader(cayenneTable, this.getCreateCallbackMethodAction().buildButton(), new ButtonListener(callbackType), ModelerUtil.buildIcon("icon-create-method.png"));
        return cayenneTable;
    }

    private JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.getRemoveCallbackMethodAction().buildMenu());
        popup.addSeparator();
        popup.add(this.getCopyCallbackMethodAction().buildMenu());
        popup.add(this.getCutCallbackMethodAction().buildMenu());
        popup.add(this.getPasteCallbackMethodAction().buildMenu());
        return popup;
    }

    private JPanel createTablePanel(CayenneTable cayenneTable) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)cayenneTable.getTableHeader(), "North");
        panel.add((Component)cayenneTable, "Center");
        return panel;
    }

    private void addButtonAtHeader(JTable table, JButton button, ActionListener buttonListener, ImageIcon buttonIcon) {
        PanelBuilder builder = new PanelBuilder(new FormLayout("left:10dlu, 2dlu", "center:14dlu"));
        CellConstraints cc = new CellConstraints();
        button.setIcon(buttonIcon);
        button.setOpaque(false);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.addActionListener(buttonListener);
        builder.add((Component)button, cc.xy(1, 1));
        JPanel buttonPanel = builder.getPanel();
        buttonPanel.setOpaque(false);
        JTableHeader header = table.getTableHeader();
        header.setLayout(new BorderLayout());
        header.setReorderingAllowed(false);
        header.setPreferredSize(new Dimension(150, 22));
        header.add((Component)buttonPanel, "East");
    }

    protected final CallbackType getSelectedCallbackType() {
        return this.mediator.getCurrentCallbackType();
    }

    private void selectAdded() {
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            if (this.callbackTypes[i] != this.getSelectedCallbackType() || !this.tables[i].editCellAt(this.tables[i].getRowCount() - 1, 0) || this.tables[i].getEditorComponent() == null) continue;
            this.tables[i].changeSelection(this.tables[i].getRowCount() - 1, 0, false, false);
            this.tables[i].getCellEditor().stopCellEditing();
            return;
        }
    }

    private void unselectAll() {
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            if (this.tables[i].getCellEditor() != null) {
                this.tables[i].getCellEditor().stopCellEditing();
            }
            this.tables[i].clearSelection();
        }
    }

    private class CallbackMouseMotionListener
    implements MouseMotionListener {
        CayenneTable table;

        public CallbackMouseMotionListener(CayenneTable table) {
            this.table = table;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.table.getColumnWidthChanged()) {
                AbstractCallbackMethodsTab.this.tablePreferences.bind(this.table, null, null, null);
                for (CayenneTable nextTable : AbstractCallbackMethodsTab.this.tables) {
                    if (this.table.equals(nextTable)) continue;
                    nextTable.getColumnModel().getColumn(0).setPreferredWidth(this.table.getWidth());
                }
            }
        }
    }

    private class CallbackMouseAdapter
    extends MouseAdapter {
        CayenneTable table;

        public CallbackMouseAdapter(CayenneTable table) {
            this.table = table;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.table.getColumnWidthChanged()) {
                for (CayenneTable nextTable : AbstractCallbackMethodsTab.this.tables) {
                    nextTable.getColumnModel().getColumn(0).setPreferredWidth(this.table.getWidth());
                }
                AbstractCallbackMethodsTab.this.initTablePreferences();
                this.table.setColumnWidthChanged(false);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && e.getComponent() instanceof JTableHeader) {
                AbstractCallbackMethodsTab.this.unselectAll();
                AbstractCallbackMethodsTab.this.mediator.setCurrentCallbackType(((CallbackDescriptorTableModel)this.table.getCayenneModel()).getCallbackType());
                AbstractCallbackMethodsTab.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class CallbackTableColumnModelListener
    implements TableColumnModelListener {
        private CayenneTable table;

        public CallbackTableColumnModelListener(CayenneTable table) {
            this.table = table;
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            if (!this.table.getColumnWidthChanged() && this.table.getTableHeader().getResizingColumn() != null) {
                this.table.setColumnWidthChanged(true);
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    private class CallbackListSelectionListener
    implements ListSelectionListener {
        private CayenneTable table;

        public CallbackListSelectionListener(CayenneTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ObjCallbackMethod[] methods = new ObjCallbackMethod[]{};
                if (!((ListSelectionModel)e.getSource()).isSelectionEmpty()) {
                    for (CayenneTable nextTable : AbstractCallbackMethodsTab.this.tables) {
                        if (nextTable.equals(this.table)) continue;
                        nextTable.clearSelection();
                        if (nextTable.getCellEditor() == null) continue;
                        nextTable.getCellEditor().stopCellEditing();
                    }
                    AbstractCallbackMethodsTab.this.mediator.setCurrentCallbackType(((CallbackDescriptorTableModel)this.table.getCayenneModel()).getCallbackType());
                }
                if (this.table.getSelectedRow() != -1) {
                    int[] sel = this.table.getSelectedRows();
                    CallbackType callbackType = AbstractCallbackMethodsTab.this.mediator.getCurrentCallbackType();
                    methods = new ObjCallbackMethod[sel.length];
                    for (int i = 0; i < sel.length; ++i) {
                        String methodName = (String)this.table.getValueAt(sel[i], this.table.convertColumnIndexToView(0));
                        methods[i] = new ObjCallbackMethod(methodName, callbackType);
                    }
                }
                AbstractCallbackMethodsTab.this.mediator.setCurrentCallbackMethods(methods);
                boolean enabled = methods.length > 0;
                boolean multiple = methods.length > 1;
                AbstractCallbackMethodsTab.this.getRemoveCallbackMethodAction().setEnabled(enabled);
                AbstractCallbackMethodsTab.this.getRemoveCallbackMethodAction().setName(AbstractCallbackMethodsTab.this.getRemoveCallbackMethodAction().getActionName(multiple));
                AbstractCallbackMethodsTab.this.getCopyCallbackMethodAction().setEnabled(enabled);
                AbstractCallbackMethodsTab.this.getCopyCallbackMethodAction().setName(AbstractCallbackMethodsTab.this.getCopyCallbackMethodAction().getActionName(multiple));
                AbstractCallbackMethodsTab.this.getCutCallbackMethodAction().setEnabled(enabled);
                AbstractCallbackMethodsTab.this.getCutCallbackMethodAction().setName(AbstractCallbackMethodsTab.this.getCutCallbackMethodAction().getActionName(multiple));
            }
        }
    }

    private class CallbackImportableHandler
    extends TransferHandler {
        private CayenneTable table;

        public CallbackImportableHandler(CayenneTable table) {
            this.table = table;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            int rowIndex = this.table.getSelectedRow();
            String result = null;
            if (rowIndex >= 0 && rowIndex < this.table.getModel().getRowCount()) {
                result = String.valueOf(this.table.getModel().getValueAt(rowIndex, 0));
            }
            return new StringSelection(result);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (this.canImport(comp, t.getTransferDataFlavors())) {
                String callbackMethod;
                try {
                    callbackMethod = (String)t.getTransferData(DataFlavor.stringFlavor);
                }
                catch (Exception e) {
                    logger.warn("Error transferring", e);
                    return false;
                }
                int rowIndex = this.table.getSelectedRow();
                CallbackDescriptor callbackDescriptor = ((CallbackDescriptorTableModel)this.table.getCayenneModel()).getCallbackDescriptor();
                AbstractCallbackMethodsTab.this.mediator.setDirty(callbackDescriptor.moveMethod(callbackMethod, rowIndex));
                AbstractCallbackMethodsTab.this.rebuildTables();
                return true;
            }
            return false;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            for (DataFlavor flavor : transferFlavors) {
                if (!DataFlavor.stringFlavor.equals(flavor)) continue;
                return true;
            }
            return false;
        }
    }

    class ButtonListener
    implements ActionListener {
        private CallbackType callbackType;

        public ButtonListener(CallbackType callbackType) {
            this.callbackType = callbackType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractCallbackMethodsTab.this.mediator.setCurrentCallbackType(this.callbackType);
        }
    }
}

