/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.cayenne.map.DataMap;

public class ClassesTabPanel
extends JPanel {
    protected JTable table;
    protected JCheckBox checkAll;
    protected JLabel checkAllLabel;
    private Map<DataMap, JTable> dataMapTables = new HashMap<DataMap, JTable>();
    private Map<DataMap, JCheckBox> dataMapJCheckBoxMap = new HashMap<DataMap, JCheckBox>();

    public ClassesTabPanel(Collection<DataMap> dataMaps) {
        this.table = new JTable();
        this.table.setRowHeight(22);
        this.checkAll = new JCheckBox();
        this.checkAllLabel = new JLabel("Check All Classes");
        this.checkAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (ClassesTabPanel.this.checkAll.isSelected()) {
                    ClassesTabPanel.this.checkAllLabel.setText("Uncheck All Classess");
                    for (DataMap dataMap : ClassesTabPanel.this.dataMapJCheckBoxMap.keySet()) {
                        ((JCheckBox)ClassesTabPanel.this.dataMapJCheckBoxMap.get(dataMap)).setSelected(true);
                    }
                } else {
                    ClassesTabPanel.this.checkAllLabel.setText("Check All Classes");
                    for (DataMap dataMap : ClassesTabPanel.this.dataMapJCheckBoxMap.keySet()) {
                        ((JCheckBox)ClassesTabPanel.this.dataMapJCheckBoxMap.get(dataMap)).setSelected(false);
                    }
                }
            }
        });
        JPanel topPanel = new JPanel(new FlowLayout(1));
        topPanel.setBorder(UIManager.getBorder("ToolBar.border"));
        topPanel.add(this.checkAll);
        topPanel.add(this.checkAllLabel);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (DataMap dataMap : dataMaps) {
            JTable table = new JTable();
            table.setRowHeight(22);
            this.dataMapTables.put(dataMap, table);
            JPanel scrollTable = new JPanel(new BorderLayout());
            scrollTable.add((Component)this.dataMapTables.get(dataMap).getTableHeader(), "North");
            scrollTable.add((Component)this.dataMapTables.get(dataMap), "Center");
            scrollTable.setPreferredSize(new Dimension(this.dataMapTables.get((Object)dataMap).getPreferredSize().width, (dataMap.getEmbeddables().size() + dataMap.getObjEntities().size()) * this.dataMapTables.get(dataMap).getRowHeight() + 45));
            JPanel labelPanel = new JPanel(new BorderLayout());
            labelPanel.setPreferredSize(new Dimension(this.dataMapTables.get((Object)dataMap).getPreferredSize().width, 20));
            JLabel dataMapLabel = new JLabel(dataMap.getName());
            dataMapLabel.setAlignmentX(0.5f);
            dataMapLabel.setBorder(new EmptyBorder(8, 8, 8, 0));
            labelPanel.add((Component)dataMapLabel, "Center");
            JCheckBox dataMapCheckBox = new JCheckBox();
            this.dataMapJCheckBoxMap.put(dataMap, dataMapCheckBox);
            labelPanel.add((Component)dataMapCheckBox, "West");
            JPanel currPanel = new JPanel(new BorderLayout());
            currPanel.add((Component)labelPanel, "North");
            currPanel.add((Component)scrollTable, "Center");
            panel.add(currPanel);
        }
        JScrollPane tablePanel = new JScrollPane(panel, 20, 31);
        tablePanel.setPreferredSize(new Dimension(450, 400));
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)tablePanel, "Center");
    }

    public boolean isAllCheckBoxesFromDataMapSelected(DataMap dataMap) {
        JTable table = this.dataMapTables.get(dataMap);
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (((Boolean)table.getModel().getValueAt(i, 0)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Map<DataMap, JTable> getDataMapTables() {
        return this.dataMapTables;
    }

    public Map<DataMap, JCheckBox> getDataMapJCheckBoxMap() {
        return this.dataMapJCheckBoxMap;
    }

    public JCheckBox getCheckAll() {
        return this.checkAll;
    }
}

