/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.FSPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeTemplateManager {
    public static final String STANDARD_SERVER_SUPERCLASS = "Standard Server Superclass";
    public static final String STANDARD_SERVER_SUBCLASS = "Standard Server Subclass";
    public static final String SINGLE_SERVER_CLASS = "Single Server class";
    static final String STANDARD_CLIENT_SUPERCLASS = "Standard Client Superclass";
    static final String STANDARD_CLIENT_SUBCLASS = "Standard Client Subclass";
    public static final String NODE_NAME = "codeTemplateManager";
    protected List<String> standardSubclassTemplates;
    protected List<String> standardSuperclassTemplates = new ArrayList<String>(3);
    protected Map<String, String> customTemplates;
    protected Map<String, String> standardTemplates;
    private static Logger logger = LoggerFactory.getLogger(CodeTemplateManager.class);

    public Preferences getTemplatePreferences(Application application) {
        return application.getPreferencesNode(this.getClass(), NODE_NAME);
    }

    public CodeTemplateManager(Application application) {
        this.standardSuperclassTemplates.add(STANDARD_SERVER_SUPERCLASS);
        this.standardSuperclassTemplates.add(STANDARD_CLIENT_SUPERCLASS);
        this.standardSubclassTemplates = new ArrayList<String>(3);
        this.standardSubclassTemplates.add(STANDARD_SERVER_SUBCLASS);
        this.standardSubclassTemplates.add(STANDARD_CLIENT_SUBCLASS);
        this.standardSubclassTemplates.add(SINGLE_SERVER_CLASS);
        this.updateCustomTemplates(this.getTemplatePreferences(application));
        this.standardTemplates = new HashMap<String, String>();
        this.standardTemplates.put(STANDARD_SERVER_SUPERCLASS, "templates/v1_2/superclass.vm");
        this.standardTemplates.put(STANDARD_CLIENT_SUPERCLASS, "templates/v1_2/client-superclass.vm");
        this.standardTemplates.put(STANDARD_SERVER_SUBCLASS, "templates/v1_2/subclass.vm");
        this.standardTemplates.put(STANDARD_CLIENT_SUBCLASS, "templates/v1_2/client-subclass.vm");
        this.standardTemplates.put(SINGLE_SERVER_CLASS, "templates/v1_2/singleclass.vm");
    }

    public void updateCustomTemplates(Preferences preference) {
        String[] keys = null;
        try {
            keys = preference.childrenNames();
        }
        catch (BackingStoreException e) {
            logger.warn("Error reading preferences");
        }
        this.customTemplates = new HashMap<String, String>(keys.length, 1.0f);
        for (int j = 0; j < keys.length; ++j) {
            FSPath path = new FSPath(preference.node(keys[j]));
            this.customTemplates.put(keys[j], path.getPath());
        }
    }

    public String getTemplatePath(String name) {
        String value = this.customTemplates.get(name);
        if (value != null) {
            return value.toString();
        }
        value = this.standardTemplates.get(name);
        return value != null ? value.toString() : null;
    }

    public Map<String, String> getCustomTemplates() {
        return this.customTemplates;
    }

    public List<String> getStandardSubclassTemplates() {
        return this.standardSubclassTemplates;
    }

    public List<String> getStandardSuperclassTemplates() {
        return this.standardSuperclassTemplates;
    }
}

