/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.v8;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.project.upgrade.BaseUpgradeHandler;
import org.apache.cayenne.project.upgrade.UpgradeHandler;
import org.apache.cayenne.project.upgrade.UpgradeMetaData;
import org.apache.cayenne.project.upgrade.v7.ProjectUpgrader_V7;
import org.apache.cayenne.resource.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpgradeHandler_V8
extends BaseUpgradeHandler {
    static final String PREVIOUS_VERSION = "7";
    static final String TO_VERSION = "8";
    @Inject
    protected Injector injector;
    @Inject
    private ProjectSaver projectSaver;

    public UpgradeHandler_V8(Resource source) {
        super(source);
    }

    @Override
    protected Resource doPerformUpgrade(UpgradeMetaData metaData) throws ConfigurationException {
        if (this.compareVersions(metaData.getProjectVersion(), PREVIOUS_VERSION) == -1) {
            ProjectUpgrader_V7 upgraderV7 = new ProjectUpgrader_V7();
            this.injector.injectMembers((Object)upgraderV7);
            UpgradeHandler handlerV7 = upgraderV7.getUpgradeHandler(this.projectSource);
            this.projectSource = handlerV7.performUpgrade();
        }
        this.upgradeFactories(this.projectSource);
        XMLDataChannelDescriptorLoader loader = new XMLDataChannelDescriptorLoader();
        this.injector.injectMembers((Object)loader);
        ConfigurationTree tree = loader.load(this.projectSource);
        Project project = new Project(tree);
        this.projectSaver.save(project);
        return project.getConfigurationResource();
    }

    private void upgradeFactories(Resource projectSource) {
        Document projectDoc = this.readDOMDocument(projectSource);
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate("/domain/map/@name", projectDoc, XPathConstants.NODESET);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node mapNode = nodes.item(i);
                Resource mapResource = projectSource.getRelativeResource(mapNode.getNodeValue() + ".map.xml");
                Document datamapDoc = this.readDOMDocument(mapResource);
                NodeList queryNodes = (NodeList)xpath.evaluate("/data-map/query", datamapDoc, XPathConstants.NODESET);
                for (int j = 0; j < queryNodes.getLength(); ++j) {
                    String queryType;
                    Element queryElement = (Element)queryNodes.item(j);
                    String factory = queryElement.getAttribute("factory");
                    if (factory == null || factory.isEmpty()) continue;
                    switch (factory) {
                        case "org.apache.cayenne.map.SelectQueryBuilder": {
                            queryType = "SelectQuery";
                            break;
                        }
                        case "org.apache.cayenne.map.SQLTemplateBuilder": {
                            queryType = "SQLTemplate";
                            break;
                        }
                        case "org.apache.cayenne.map.EjbqlBuilder": {
                            queryType = "EJBQLQuery";
                            break;
                        }
                        case "org.apache.cayenne.map.ProcedureQueryBuilder": {
                            queryType = "ProcedureQuery";
                            break;
                        }
                        default: {
                            throw new ConfigurationException("Unknown query factory: " + factory, new Object[0]);
                        }
                    }
                    queryElement.setAttribute("type", queryType);
                    queryElement.removeAttribute("factory");
                }
                DOMSource domSource = new DOMSource(datamapDoc);
                StreamResult result = new StreamResult(new FileOutputStream(new File(mapResource.getURL().getPath())));
                transformer.transform(domSource, result);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to parse Cayenne XML configuration files.", (Throwable)e, new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document readDOMDocument(Resource resource) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder domBuilder = documentBuilderFactory.newDocumentBuilder();
            try (InputStream inputStream = resource.getURL().openStream();){
                Document document = domBuilder.parse(inputStream);
                return document;
            }
            catch (IOException | SAXException e) {
                throw new ConfigurationException("Error loading configuration from %s", (Throwable)e, new Object[]{resource});
            }
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    @Override
    protected String getToVersion() {
        return TO_VERSION;
    }
}

