/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.google.common.annotations.Beta;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.util.guava.Maybe;

public class BrooklynJacksonType
extends SimpleType
implements TypeVariable<GenericDeclaration> {
    private final RegisteredType type;

    BrooklynJacksonType(RegisteredType type) {
        super(BrooklynJacksonType.pickSuperType(type));
        this.type = type;
    }

    public RegisteredType getRegisteredType() {
        return this.type;
    }

    @Override
    public String getTypeName() {
        return this.type.getId();
    }

    public String toString() {
        return "BrooklynJacksonType{" + this.type.getId() + '/' + this._class + "}";
    }

    @Override
    public Type[] getBounds() {
        return new Type[]{this.getRawClass()};
    }

    @Override
    public GenericDeclaration getGenericDeclaration() {
        return new FakeGenericDeclaration();
    }

    @Override
    public String getName() {
        return this.getTypeName();
    }

    @Override
    public AnnotatedType[] getAnnotatedBounds() {
        return new AnnotatedType[0];
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return new Annotation[0];
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return new Annotation[0];
    }

    public static <T> Maybe<RegisteredType> getRegisteredType(TypeToken<T> tt) {
        Type type = tt.getType();
        if (type instanceof BrooklynJacksonType) {
            return Maybe.ofDisallowingNull((Object)((BrooklynJacksonType)type).getRegisteredType());
        }
        return Maybe.absent();
    }

    public static <T> boolean isRegisteredType(TypeToken<T> tt) {
        return BrooklynJacksonType.getRegisteredType(tt).isPresent();
    }

    @Beta
    public static Class<?> pickSuperType(RegisteredType t) {
        for (Object x : t.getSuperTypes()) {
            if (!(x instanceof Class)) continue;
            return (Class)x;
        }
        return Object.class;
    }

    public static BrooklynJacksonType of(RegisteredType rt) {
        return new BrooklynJacksonType(rt);
    }

    public static <T> TypeReference<T> asTypeReference(final ManagementContext mgmt, final String rtName) {
        return new TypeReference<T>(){

            public Type getType() {
                RegisteredType rt = mgmt.getTypeRegistry().get(rtName);
                if (rt == null) {
                    throw new IllegalStateException("Unknown type '" + rtName + "'");
                }
                return new BrooklynJacksonType(rt);
            }
        };
    }

    public static <T> TypeReference<T> asTypeReference(final RegisteredType rt) {
        return new TypeReference<T>(){

            public Type getType() {
                return new BrooklynJacksonType(rt);
            }
        };
    }

    public static <T> TypeReference<T> asTypeReference(final TypeToken<T> typeToken) {
        return new TypeReference<T>(){

            public Type getType() {
                return typeToken.getType();
            }
        };
    }

    public static <T> JavaType asJavaType(ObjectMapper m, TypeToken<T> tt) {
        Type type = tt.getType();
        if (type instanceof BrooklynJacksonType) {
            return (BrooklynJacksonType)type;
        }
        return m.constructType(tt.getType());
    }

    public static <T> TypeToken<T> asTypeToken(RegisteredType rt) {
        return TypeToken.of((Type)BrooklynJacksonType.of(rt));
    }

    private static class FakeGenericDeclaration
    implements GenericDeclaration {
        private FakeGenericDeclaration() {
        }

        @Override
        public TypeVariable<?>[] getTypeParameters() {
            return new TypeVariable[0];
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }

        public boolean equals(Object obj) {
            return true;
        }
    }
}

