/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.installer.libvirt.v1.Network;
import io.fabric8.openshift.api.model.installer.libvirt.v1.NetworkFluent;

public class NetworkBuilder
extends NetworkFluent<NetworkBuilder>
implements VisitableBuilder<Network, NetworkBuilder> {
    NetworkFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkBuilder() {
        this(false);
    }

    public NetworkBuilder(Boolean validationEnabled) {
        this(new Network(), validationEnabled);
    }

    public NetworkBuilder(NetworkFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkBuilder(NetworkFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Network(), validationEnabled);
    }

    public NetworkBuilder(NetworkFluent<?> fluent, Network instance) {
        this(fluent, instance, false);
    }

    public NetworkBuilder(NetworkFluent<?> fluent, Network instance, Boolean validationEnabled) {
        this.fluent = fluent;
        Network network = instance = instance != null ? instance : new Network();
        if (instance != null) {
            fluent.withDnsmasqOptions(instance.getDnsmasqOptions());
            fluent.withIf(instance.getIf());
            fluent.withDnsmasqOptions(instance.getDnsmasqOptions());
            fluent.withIf(instance.getIf());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public NetworkBuilder(Network instance) {
        this(instance, (Boolean)false);
    }

    public NetworkBuilder(Network instance, Boolean validationEnabled) {
        this.fluent = this;
        Network network = instance = instance != null ? instance : new Network();
        if (instance != null) {
            this.withDnsmasqOptions(instance.getDnsmasqOptions());
            this.withIf(instance.getIf());
            this.withDnsmasqOptions(instance.getDnsmasqOptions());
            this.withIf(instance.getIf());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public Network build() {
        Network buildable = new Network(this.fluent.buildDnsmasqOptions(), this.fluent.getIf());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

