/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultConfigDataLoader;
import org.springframework.cloud.vault.config.VaultKeyValueBackendProperties;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptorFactory;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.vault.authentication.LifecycleAwareSessionManager;
import org.springframework.vault.authentication.LifecycleAwareSessionManagerSupport;
import org.springframework.vault.authentication.ReactiveLifecycleAwareSessionManager;
import org.springframework.vault.authentication.SimpleSessionManager;
import org.springframework.vault.client.ClientHttpRequestFactoryFactory;
import org.springframework.vault.core.env.LeaseAwareVaultPropertySource;
import org.springframework.vault.core.env.VaultPropertySource;

class VaultRuntimeHints
implements RuntimeHintsRegistrar {
    VaultRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        ReflectionHints reflection = hints.reflection();
        reflection.registerTypes((Iterable)Arrays.asList(SimpleSessionManager.class, LifecycleAwareSessionManager.class, LifecycleAwareSessionManagerSupport.class, ClientHttpRequestFactoryFactory.class, VaultPropertySource.class, LeaseAwareVaultPropertySource.class).stream().map(TypeReference::of).collect(Collectors.toList()), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS}));
        reflection.registerTypes((Iterable)Arrays.asList(VaultKeyValueBackendProperties.class).stream().map(TypeReference::of).collect(Collectors.toList()), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS}));
        reflection.registerType(TypeReference.of((String)"org.springframework.vault.core.lease.SecretLeaseContainer$LeaseRenewalScheduler"), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS}));
        reflection.registerType(TypeReference.of((String)"org.springframework.vault.core.lease.SecretLeaseEventPublisher$LoggingErrorListener"), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS}));
        reflection.registerType(TypeReference.of((String)"org.springframework.cloud.vault.config.VaultReactiveConfiguration$ReactiveSessionManagerAdapter"), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS}));
        if (VaultConfigDataLoader.webclientPresent && VaultConfigDataLoader.reactorPresent) {
            reflection.registerTypes((Iterable)Arrays.asList(ReactiveLifecycleAwareSessionManager.class).stream().map(TypeReference::of).collect(Collectors.toList()), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS}));
        }
        reflection.registerTypeIfPresent(classLoader, "reactor.core.publisher.Flux", new MemberCategory[]{MemberCategory.PUBLIC_CLASSES});
        reflection.registerTypeIfPresent(classLoader, "org.springframework.web.reactive.function.client.WebClient", new MemberCategory[]{MemberCategory.PUBLIC_CLASSES});
        reflection.registerTypeIfPresent(classLoader, "org.bouncycastle.crypto.signers.PSSSigner", new MemberCategory[]{MemberCategory.PUBLIC_CLASSES});
        reflection.registerTypeIfPresent(classLoader, "com.google.api.client.googleapis.auth.oauth2.GoogleCredential", new MemberCategory[]{MemberCategory.PUBLIC_CLASSES});
        reflection.registerTypeIfPresent(classLoader, "com.google.auth.oauth2.GoogleCredentials", new MemberCategory[]{MemberCategory.PUBLIC_CLASSES});
        ArrayList pluggableDescriptors = new ArrayList();
        pluggableDescriptors.addAll(SpringFactoriesLoader.loadFactories(SecretBackendMetadataFactory.class, (ClassLoader)classLoader));
        pluggableDescriptors.addAll(SpringFactoriesLoader.loadFactories(VaultSecretBackendDescriptor.class, (ClassLoader)classLoader));
        pluggableDescriptors.addAll(SpringFactoriesLoader.loadFactories(VaultSecretBackendDescriptorFactory.class, (ClassLoader)classLoader));
        List pluggableDescriptorReferences = pluggableDescriptors.stream().map(Object::getClass).map(TypeReference::of).collect(Collectors.toList());
        reflection.registerTypes(pluggableDescriptorReferences, builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_METHODS}));
    }
}

