/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class ArrayDdlTypeImpl
extends DdlTypeImpl {
    private final boolean castRawElementType;

    public ArrayDdlTypeImpl(Dialect dialect, boolean castRawElementType) {
        super(2003, "array", dialect);
        this.castRawElementType = castRawElementType;
    }

    @Override
    public String getCastTypeName(Size columnSize, SqlExpressible type, DdlTypeRegistry ddlTypeRegistry) {
        int paren;
        BasicPluralType pluralType = (BasicPluralType)type;
        BasicPluralJavaType javaTypeDescriptor = (BasicPluralJavaType)((Object)pluralType.getJavaTypeDescriptor());
        BasicType elementType = pluralType.getElementType();
        String arrayElementTypeName = ddlTypeRegistry.getDescriptor(elementType.getJdbcType().getDdlTypeCode()).getCastTypeName(this.dialect.getSizeStrategy().resolveSize(elementType.getJdbcMapping().getJdbcType(), elementType.getJavaTypeDescriptor(), columnSize.getPrecision(), columnSize.getScale(), columnSize.getLength()), elementType, ddlTypeRegistry);
        if (this.castRawElementType && (paren = arrayElementTypeName.indexOf(40)) > 0) {
            int parenEnd = arrayElementTypeName.lastIndexOf(41);
            arrayElementTypeName = parenEnd + 1 == arrayElementTypeName.length() ? arrayElementTypeName.substring(0, paren) : arrayElementTypeName.substring(0, paren) + arrayElementTypeName.substring(parenEnd + 1);
        }
        return this.dialect.getArrayTypeName(javaTypeDescriptor.getElementJavaType().getJavaTypeClass().getSimpleName(), arrayElementTypeName, columnSize.getArrayLength());
    }

    @Override
    public String getTypeName(Size columnSize, Type type, DdlTypeRegistry ddlTypeRegistry) {
        BasicPluralType pluralType = (BasicPluralType)type;
        BasicPluralJavaType javaTypeDescriptor = (BasicPluralJavaType)((Object)pluralType.getJavaTypeDescriptor());
        BasicType elementType = pluralType.getElementType();
        String arrayElementTypeName = ddlTypeRegistry.getTypeName(elementType.getJdbcType().getDdlTypeCode(), this.dialect.getSizeStrategy().resolveSize(elementType.getJdbcMapping().getJdbcType(), elementType.getJavaTypeDescriptor(), columnSize.getPrecision(), columnSize.getScale(), columnSize.getLength()), elementType);
        return this.dialect.getArrayTypeName(javaTypeDescriptor.getElementJavaType().getJavaTypeClass().getSimpleName(), arrayElementTypeName, columnSize.getArrayLength());
    }
}

