/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractBatchEntitySelectFetchInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    protected final FetchParentAccess parentAccess;
    private final NavigablePath navigablePath;
    protected final EntityPersister concreteDescriptor;
    protected final DomainResultAssembler<?> identifierAssembler;
    protected final ToOneAttributeMapping referencedModelPart;
    protected final EntityInitializer firstEntityInitializer;
    protected Object initializedEntityInstance;
    protected EntityKey entityKey;
    protected State state = State.UNINITIALIZED;

    public AbstractBatchEntitySelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping referencedModelPart, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler<?> identifierAssembler) {
        this.parentAccess = parentAccess;
        this.referencedModelPart = referencedModelPart;
        this.navigablePath = fetchedNavigable;
        this.concreteDescriptor = concreteDescriptor;
        this.identifierAssembler = identifierAssembler;
        this.firstEntityInitializer = parentAccess.findFirstEntityInitializer();
        assert (this.firstEntityInitializer != null) : "This initializer requires parentAccess.findFirstEntityInitializer() to not be null";
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
    }

    protected abstract void registerResolutionListener();

    protected void resolveKey(RowProcessingState rowProcessingState, ToOneAttributeMapping referencedModelPart, FetchParentAccess parentAccess) {
        if (this.state != State.UNINITIALIZED) {
            return;
        }
        if (!this.isAttributeAssignableToConcreteDescriptor(parentAccess, referencedModelPart)) {
            this.state = State.MISSING;
            return;
        }
        Object entityIdentifier = this.identifierAssembler.assemble(rowProcessingState);
        if (entityIdentifier == null) {
            this.state = State.MISSING;
        } else {
            this.entityKey = new EntityKey(entityIdentifier, this.concreteDescriptor);
            this.state = State.KEY_RESOLVED;
        }
    }

    protected Object getExistingInitializedInstance(RowProcessingState rowProcessingState) {
        assert (this.entityKey != null);
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        EntityHolder holder = persistenceContext.getEntityHolder(this.entityKey);
        if (holder != null && holder.getEntity() != null && holder.isEventuallyInitialized()) {
            return holder.getEntity();
        }
        this.registerResolutionListener();
        return null;
    }

    private boolean isInitialized(Object entity) {
        PersistentAttributeInterceptable attributeInterceptable = ManagedTypeHelper.asPersistentAttributeInterceptableOrNull(entity);
        if (attributeInterceptable == null) {
            return true;
        }
        PersistentAttributeInterceptor interceptor = attributeInterceptable.$$_hibernate_getInterceptor();
        if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
            return ((EnhancementAsProxyLazinessInterceptor)interceptor).isInitialized();
        }
        return true;
    }

    protected void registerToBatchFetchQueue(RowProcessingState rowProcessingState) {
        assert (this.entityKey != null);
        rowProcessingState.getSession().getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(this.entityKey);
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.initializedEntityInstance = null;
        this.entityKey = null;
        this.state = State.UNINITIALIZED;
        this.clearResolutionListeners();
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.initializedEntityInstance;
    }

    @Override
    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    @Override
    public Object getParentKey() {
        return this.findFirstEntityInitializer().getEntityKey().getIdentifier();
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.initializedEntityInstance != null) {
            listener.accept(this.initializedEntityInstance);
        } else {
            super.registerResolutionListener(listener);
        }
    }

    protected static Object loadInstance(EntityKey entityKey, ToOneAttributeMapping referencedModelPart, SharedSessionContractImplementor session) {
        return session.internalLoad(entityKey.getEntityName(), entityKey.getIdentifier(), true, referencedModelPart.isInternalLoadNullable());
    }

    protected AttributeMapping getParentEntityAttribute(String attributeName) {
        AttributeMapping parentAttribute = this.firstEntityInitializer.getConcreteDescriptor().findAttributeMapping(attributeName);
        if (parentAttribute != null && parentAttribute.getDeclaringType() == this.referencedModelPart.getDeclaringType().findContainingEntityMapping()) {
            return parentAttribute;
        }
        return null;
    }

    @Override
    public FetchParentAccess getFetchParentAccess() {
        return this.parentAccess;
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.concreteDescriptor;
    }

    static enum State {
        UNINITIALIZED,
        MISSING,
        KEY_RESOLVED,
        INITIALIZED;

    }
}

