/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import org.hibernate.Incubating;

@Incubating
public class Page {
    private final int size;
    private final int number;

    public int getSize() {
        return this.size;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isFirst() {
        return this.number == 0;
    }

    public int getMaxResults() {
        return this.size;
    }

    public int getFirstResult() {
        return this.size * this.number;
    }

    private Page(int size, int number) {
        if (size <= 0) {
            throw new IllegalArgumentException("page size must be strictly positive");
        }
        if (number < 0) {
            throw new IllegalArgumentException("page number must be non-negative");
        }
        this.size = size;
        this.number = number;
    }

    public static Page page(int size, int number) {
        return new Page(size, number);
    }

    public static Page first(int size) {
        return new Page(size, 0);
    }

    public Page next() {
        return new Page(this.size, this.number + 1);
    }

    public Page previous() {
        if (this.isFirst()) {
            throw new IllegalStateException("already at first page");
        }
        return new Page(this.size, this.number - 1);
    }

    public Page first() {
        return Page.first(this.size);
    }
}

