/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.util.StringHelper;

class ColumnsBuilder {
    private final PropertyHolder propertyHolder;
    private final Nullability nullability;
    private final XProperty property;
    private final PropertyData inferredData;
    private final EntityBinder entityBinder;
    private final MetadataBuildingContext buildingContext;
    private AnnotatedColumns columns;
    private AnnotatedJoinColumns joinColumns;

    public ColumnsBuilder(PropertyHolder propertyHolder, Nullability nullability, XProperty property, PropertyData inferredData, EntityBinder entityBinder, MetadataBuildingContext buildingContext) {
        this.propertyHolder = propertyHolder;
        this.nullability = nullability;
        this.property = property;
        this.inferredData = inferredData;
        this.entityBinder = entityBinder;
        this.buildingContext = buildingContext;
    }

    public AnnotatedColumns getColumns() {
        return this.columns;
    }

    public AnnotatedJoinColumns getJoinColumns() {
        return this.joinColumns;
    }

    public ColumnsBuilder extractMetadata() {
        this.columns = null;
        this.joinColumns = this.buildExplicitJoinColumns(this.property, this.inferredData);
        if (this.property.isAnnotationPresent(Column.class)) {
            this.columns = AnnotatedColumn.buildColumnFromAnnotation((Column)this.property.getAnnotation(Column.class), this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        } else if (this.property.isAnnotationPresent(Formula.class)) {
            this.columns = AnnotatedColumn.buildFormulaFromAnnotation(BinderHelper.getOverridableAnnotation((XAnnotatedElement)this.property, Formula.class, this.buildingContext), this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        } else if (this.property.isAnnotationPresent(Columns.class)) {
            this.columns = AnnotatedColumn.buildColumnsFromAnnotations(((Columns)this.property.getAnnotation(Columns.class)).columns(), this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        }
        if (this.joinColumns == null && (this.property.isAnnotationPresent(ManyToOne.class) || this.property.isAnnotationPresent(OneToOne.class))) {
            this.joinColumns = this.buildDefaultJoinColumnsForToOne(this.property, this.inferredData);
        } else if (this.joinColumns == null && (this.property.isAnnotationPresent(OneToMany.class) || this.property.isAnnotationPresent(ElementCollection.class))) {
            OneToMany oneToMany = (OneToMany)this.property.getAnnotation(OneToMany.class);
            this.joinColumns = AnnotatedJoinColumns.buildJoinColumns(null, oneToMany == null ? null : StringHelper.nullIfEmpty(oneToMany.mappedBy()), this.entityBinder.getSecondaryTables(), this.propertyHolder, this.inferredData, this.buildingContext);
        } else if (this.joinColumns == null && this.property.isAnnotationPresent(Any.class)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' is annotated '@Any' and must declare at least one '@JoinColumn'");
        }
        if (this.columns == null && !this.property.isAnnotationPresent(ManyToMany.class)) {
            this.columns = AnnotatedColumn.buildColumnFromNoAnnotation(this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        }
        if (this.nullability == Nullability.FORCED_NOT_NULL) {
            for (AnnotatedColumn column : this.columns.getColumns()) {
                column.forceNotNull();
            }
        }
        return this;
    }

    private AnnotatedJoinColumns buildDefaultJoinColumnsForToOne(XProperty property, PropertyData inferredData) {
        JoinTable joinTableAnn = this.propertyHolder.getJoinTable(property);
        if (joinTableAnn != null) {
            return AnnotatedJoinColumns.buildJoinColumns(joinTableAnn.inverseJoinColumns(), null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        OneToOne oneToOneAnn = (OneToOne)property.getAnnotation(OneToOne.class);
        return AnnotatedJoinColumns.buildJoinColumns(null, oneToOneAnn == null ? null : StringHelper.nullIfEmpty(oneToOneAnn.mappedBy()), this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
    }

    private AnnotatedJoinColumns buildExplicitJoinColumns(XProperty property, PropertyData inferredData) {
        JoinColumn[] joinColumnAnnotations = this.getJoinColumnAnnotations(property, inferredData);
        if (joinColumnAnnotations != null) {
            return AnnotatedJoinColumns.buildJoinColumns(joinColumnAnnotations, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        JoinColumnOrFormula[] joinColumnOrFormulaAnnotations = this.joinColumnOrFormulaAnnotations(property, inferredData);
        if (joinColumnOrFormulaAnnotations != null) {
            return AnnotatedJoinColumns.buildJoinColumnsOrFormulas(joinColumnOrFormulaAnnotations, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        if (property.isAnnotationPresent(JoinFormula.class)) {
            JoinFormula joinFormula = BinderHelper.getOverridableAnnotation((XAnnotatedElement)property, JoinFormula.class, this.buildingContext);
            return AnnotatedJoinColumns.buildJoinColumnsWithFormula(joinFormula, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        return null;
    }

    private JoinColumnOrFormula[] joinColumnOrFormulaAnnotations(XProperty property, PropertyData inferredData) {
        if (property.isAnnotationPresent(JoinColumnOrFormula.class)) {
            return new JoinColumnOrFormula[]{(JoinColumnOrFormula)property.getAnnotation(JoinColumnOrFormula.class)};
        }
        if (property.isAnnotationPresent(JoinColumnsOrFormulas.class)) {
            JoinColumnsOrFormulas joinColumnsOrFormulas = (JoinColumnsOrFormulas)property.getAnnotation(JoinColumnsOrFormulas.class);
            JoinColumnOrFormula[] joinColumnOrFormula = joinColumnsOrFormulas.value();
            if (joinColumnOrFormula.length == 0) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(this.propertyHolder, inferredData) + "' has an empty '@JoinColumnsOrFormulas' annotation");
            }
            return joinColumnOrFormula;
        }
        return null;
    }

    private JoinColumn[] getJoinColumnAnnotations(XProperty property, PropertyData inferredData) {
        if (property.isAnnotationPresent(JoinColumn.class)) {
            return new JoinColumn[]{(JoinColumn)property.getAnnotation(JoinColumn.class)};
        }
        if (property.isAnnotationPresent(JoinColumns.class)) {
            JoinColumns joinColumns = (JoinColumns)property.getAnnotation(JoinColumns.class);
            JoinColumn[] joinColumn = joinColumns.value();
            if (joinColumn.length == 0) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(this.propertyHolder, inferredData) + "' has an empty '@JoinColumns' annotation");
            }
            return joinColumn;
        }
        return null;
    }

    AnnotatedColumns overrideColumnFromMapperOrMapsIdProperty(boolean isId) {
        PropertyData override = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, this.propertyHolder, this.property.getName(), this.buildingContext);
        if (override != null) {
            AnnotatedJoinColumns joinColumns = this.buildExplicitJoinColumns(override.getProperty(), override);
            return joinColumns == null ? this.buildDefaultJoinColumnsForToOne(override.getProperty(), override) : joinColumns;
        }
        return this.columns;
    }
}

