/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.ArtistCredit;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.NameCredit;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Release;
import org.musicbrainz.mmd2.ReleaseGroup;
import org.musicbrainz.mmd2.ReleaseGroupList;
import org.musicbrainz.mmd2.ReleaseList;
import org.musicbrainz.mmd2.SecondaryTypeList;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.mmd2.TagList;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.helper.ArtistCreditHelper;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.ReleaseGroupIndexField;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public class ReleaseGroupWriter
extends ResultsWriter {
    public void write(Metadata metadata, Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        ReleaseGroupList releaseGroupList = of.createReleaseGroupList();
        for (Result result : results.results) {
            result.setNormalizedScore(results.getMaxScore());
        }
        this.write(releaseGroupList.getReleaseGroup(), results);
        releaseGroupList.setCount(BigInteger.valueOf(results.getTotalHits()));
        releaseGroupList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setReleaseGroupList(releaseGroupList);
    }

    public void write(List list, Results results) throws IOException {
        for (Result result : results.results) {
            this.write(list, result);
        }
    }

    public void write(List list, Result result) throws IOException {
        String[] secondaryTypes;
        String primaryType;
        String type;
        String comment;
        ObjectFactory of = new ObjectFactory();
        MbDocument doc = result.getDoc();
        ReleaseGroup releaseGroup = of.createReleaseGroup();
        releaseGroup.setId(doc.get((IndexField)ReleaseGroupIndexField.RELEASEGROUP_ID));
        releaseGroup.setScore(String.valueOf(result.getNormalizedScore()));
        String name = doc.get((IndexField)ReleaseGroupIndexField.RELEASEGROUP);
        if (name != null) {
            releaseGroup.setTitle(name);
        }
        if (this.isNotNoValue(comment = doc.get((IndexField)ReleaseGroupIndexField.COMMENT))) {
            releaseGroup.setDisambiguation(comment);
        }
        if (this.isNotUnknown(type = doc.get((IndexField)ReleaseGroupIndexField.TYPE))) {
            releaseGroup.setType(type);
        }
        if (this.isNotUnknown(primaryType = doc.get((IndexField)ReleaseGroupIndexField.PRIMARY_TYPE))) {
            releaseGroup.setPrimaryType(primaryType);
        }
        if ((secondaryTypes = doc.getValues((IndexField)ReleaseGroupIndexField.SECONDARY_TYPE)).length > 0) {
            SecondaryTypeList stl = of.createSecondaryTypeList();
            for (int i = 0; i < secondaryTypes.length; ++i) {
                stl.getSecondaryType().add(secondaryTypes[i]);
            }
            releaseGroup.setSecondaryTypeList(stl);
        }
        if (doc.get((IndexField)ReleaseGroupIndexField.ARTIST_CREDIT) != null) {
            ArtistCredit ac = ArtistCreditHelper.unserialize((String)doc.get((IndexField)ReleaseGroupIndexField.ARTIST_CREDIT));
            releaseGroup.setArtistCredit(ac);
        }
        String[] releaseIds = doc.getValues((IndexField)ReleaseGroupIndexField.RELEASE_ID);
        String[] releaseNames = doc.getValues((IndexField)ReleaseGroupIndexField.RELEASE);
        String[] releaseStatuses = doc.getValues((IndexField)ReleaseGroupIndexField.RELEASESTATUS);
        ReleaseList releaseList = of.createReleaseList();
        releaseList.setCount(BigInteger.valueOf(releaseIds.length));
        for (int i = 0; i < releaseIds.length; ++i) {
            Release release = of.createRelease();
            release.setId(releaseIds[i]);
            release.setTitle(releaseNames[i]);
            release.setStatus(releaseStatuses[i]);
            releaseList.getRelease().add(release);
        }
        releaseGroup.setReleaseList(releaseList);
        String[] tags = doc.getValues((IndexField)ReleaseGroupIndexField.TAG);
        String[] tagCounts = doc.getValues((IndexField)ReleaseGroupIndexField.TAGCOUNT);
        if (tags.length > 0) {
            TagList tagList = of.createTagList();
            for (int i = 0; i < tags.length; ++i) {
                Tag tag = of.createTag();
                tag.setName(tags[i]);
                tag.setCount(new BigInteger(tagCounts[i]));
                tagList.getTag().add(tag);
            }
            releaseGroup.setTagList(tagList);
        }
        list.add(releaseGroup);
    }

    public void adjustForJson(Metadata metadata) {
        if (metadata.getReleaseGroupList().getReleaseGroup().size() > 0) {
            for (ReleaseGroup releaseGroup : metadata.getReleaseGroupList().getReleaseGroup()) {
                if (releaseGroup.getArtistCredit() == null) continue;
                for (NameCredit nc : releaseGroup.getArtistCredit().getNameCredit()) {
                    if (nc.getArtist() == null || nc.getArtist().getAliasList() == null) continue;
                    for (Alias alias : nc.getArtist().getAliasList().getAlias()) {
                        if (alias.getPrimary() == null) continue;
                        alias.setPrimary("true");
                    }
                }
            }
        }
    }
}

