/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.type;

public enum AnnotationType {
    ARTIST(1, "artist"),
    RELEASE(2, "release"),
    LABEL(3, "label"),
    RECORDING(4, "recording"),
    RELEASE_GROUP(5, "release-group"),
    WORK(6, "work"),
    INSTRUMENT(7, "instrument"),
    SERIES(8, "series"),
    AREA(9, "area"),
    PLACE(10, "place"),
    EVENT(11, "event");

    private Integer dbId;
    private String name;

    private AnnotationType(Integer dbId, String name) {
        this.dbId = dbId;
        this.name = name;
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public String getName() {
        return this.name;
    }

    public static AnnotationType getByDbId(int id) {
        for (AnnotationType type : AnnotationType.values()) {
            if (type.getDbId() != id) continue;
            return type;
        }
        return null;
    }

    public static int getMinDbId() {
        return ARTIST.getDbId();
    }

    public static int getMaxDbId() {
        return WORK.getDbId();
    }
}

