/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.kohsuke.args4j.Option;
import org.musicbrainz.search.index.PrepareDatabase;

public class IndexOptions {
    private static final int MAX_TEST_ID = 50000;
    private static final int IDS_PER_CHUNK = 20000;
    public static final int MAX_BUFFERED_DOCS = 10000;
    public static final String DB_SCHEMA = "musicbrainz";
    @Option(name="--db-host", aliases={"-h"}, usage="The database server to connect to. (default: localhost)")
    private String mainDatabaseHost = "localhost";
    @Option(name="--db-name", aliases={"-d"}, usage="The name of the database server to connect to. (default: musicbrainz_db)")
    private String mainDatabaseName = "musicbrainz_db";
    @Option(name="--db-user", aliases={"-u"}, usage="The username to connect with. (default: musicbrainz_user)")
    private String mainDatabaseUser = "musicbrainz_user";
    @Option(name="--db-password", aliases={"-p"}, usage="The password for the db user. (default: -blank-)")
    private String mainDatabasePassword = "";
    @Option(name="--indexes-dir", usage="The directory . (default: ./data/)")
    private String indexesDir = "." + System.getProperty("file.separator") + "data" + System.getProperty("file.separator");
    @Option(name="--freedb-dump", usage="The FreeDB dump file to index.")
    private String freeDBDump = "";
    @Option(name="--indexes", usage="A comma-separated list of indexes to build (annotation,area,artist,editor,instrument,label,place,event,releasegroup,release,recording,series,work,tag,url,cdstub,freedb)")
    private String indexes = "annotation,area,artist,editor,instrument,label,place,event,release,recording,releasegroup,series,work,tag,url,cdstub,freedb";
    @Option(name="--test", aliases={"-t"}, usage="Test the index builder by creating small test indexes.")
    private boolean test = false;
    @Option(name="--help", usage="Print this usage information.")
    private boolean help = false;
    @Option(name="--testindexsize", aliases={"-b"}, usage="The number of rows to index when using the test option. (default: 50000)")
    private int testIndexSize = 50000;
    @Option(name="--chunksize", aliases={"-c"}, usage="Chunk Size, The number of rows to return in each SQL query. (default: -20000)")
    private int databaseChunkSize = 20000;
    @Option(name="--checkfilelimit", usage="Check Open File Limit, all other options are ignored and no indexes are built.")
    private boolean checkFileLimit = false;
    @Option(name="--debug", usage="Debug Mode, provides additional info, only use for debugging because runs slower.")
    private boolean debug = false;
    @Option(name="--maxbuffereddocs", usage="The Max Buffered docs before writing to index segment during Indexing. (default: 10000)")
    private int maxBufferedDocs = 10000;

    public String getMainDatabaseHost() {
        return this.mainDatabaseHost;
    }

    public String getMainDatabaseName() {
        return this.mainDatabaseName;
    }

    public String getMainDatabaseUser() {
        return this.mainDatabaseUser;
    }

    public String getMainDatabasePassword() {
        return this.mainDatabasePassword;
    }

    public Connection getMainDatabaseConnection() {
        String url = "jdbc:postgresql://" + this.getMainDatabaseHost() + "/" + this.getMainDatabaseName();
        Properties props = new Properties();
        props.setProperty("user", this.getMainDatabaseUser());
        props.setProperty("password", this.getMainDatabasePassword());
        Connection c = null;
        try {
            c = DriverManager.getConnection(url, props);
            PrepareDatabase.prepareDbConnection(c);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return c;
    }

    public String getIndexesDir() {
        if (this.indexesDir.endsWith(System.getProperty("file.separator"))) {
            return this.indexesDir;
        }
        return this.indexesDir + System.getProperty("file.separator");
    }

    public String getFreeDBDump() {
        return this.freeDBDump;
    }

    public ArrayList<String> selectedIndexes() {
        return new ArrayList<String>(Arrays.asList(this.indexes.split(",")));
    }

    public boolean buildIndex(String indexName) {
        return this.selectedIndexes().contains(indexName);
    }

    public boolean isTest() {
        return this.test;
    }

    public boolean isHelp() {
        return this.help;
    }

    public int getTestIndexSize() {
        return this.testIndexSize;
    }

    public int getDatabaseChunkSize() {
        return this.databaseChunkSize;
    }

    public boolean isCheckFileLimit() {
        return this.checkFileLimit;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }
}

