/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.musicbrainz.search.index.IndexField;

public class MbDocument {
    private Document doc;

    public MbDocument() {
        this.doc = new Document();
    }

    public MbDocument(Document doc) {
        this.doc = doc;
    }

    public Document getLuceneDocument() {
        return this.doc;
    }

    public void addField(IndexField field, String value) {
        this.doc.add(new Field(field.getName(), value, field.getFieldType()));
    }

    public void addField(IndexField field, int value) {
        this.addField(field, Integer.toString(value));
    }

    public void addNumericField(IndexField field, Integer value) {
        BytesRefBuilder bytes = new BytesRefBuilder();
        NumericUtils.intToPrefixCoded(value, 0, bytes);
        this.doc.add(new Field(field.getName(), bytes.toBytesRef().utf8ToString(), field.getFieldType()));
    }

    public void addNumericField(IndexField field, Float value) {
        BytesRefBuilder bytes = new BytesRefBuilder();
        NumericUtils.intToPrefixCoded(NumericUtils.floatToSortableInt(value.floatValue()), 0, bytes);
        this.doc.add(new Field(field.getName(), bytes.toBytesRef().utf8ToString(), field.getFieldType()));
    }

    public void addNumericField(IndexField field, Long value) {
        BytesRefBuilder bytes = new BytesRefBuilder();
        NumericUtils.longToPrefixCoded(value, 0, bytes);
        this.doc.add(new Field(field.getName(), bytes.toBytesRef().utf8ToString(), field.getFieldType()));
    }

    public void addNonEmptyField(IndexField field, String value) {
        if (value != null && !value.isEmpty()) {
            this.addField(field, value);
        }
    }

    public void addFieldOrUnknown(IndexField field, String value) {
        if (value != null && !value.isEmpty()) {
            this.doc.add(new Field(field.getName(), value, field.getFieldType()));
        } else {
            this.doc.add(new Field(field.getName(), "unknown", field.getFieldType()));
        }
    }

    public void addFieldOrNoValue(IndexField field, String value) {
        if (value != null && !value.isEmpty()) {
            this.doc.add(new Field(field.getName(), value, field.getFieldType()));
        } else {
            this.doc.add(new Field(field.getName(), "-", field.getFieldType()));
        }
    }

    public String get(IndexField indexField) {
        return this.doc.get(indexField.getName());
    }

    public Number getNumericField(IndexField indexField) {
        return this.doc.getField(indexField.getName()).numericValue();
    }

    public String[] getValues(IndexField indexField) {
        return this.doc.getValues(indexField.getName());
    }

    public IndexableField[] getFields(IndexField indexField) {
        return this.doc.getFields(indexField.getName());
    }
}

