/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.similarities.Similarity;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.DefAreaElementInner;
import org.musicbrainz.mmd2.IpiList;
import org.musicbrainz.mmd2.Label;
import org.musicbrainz.mmd2.LifeSpan;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.analysis.MusicbrainzSimilarity;
import org.musicbrainz.search.helper.AliasHelper;
import org.musicbrainz.search.helper.TagHelper;
import org.musicbrainz.search.index.ArtistIndexField;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.LabelBoostDoc;
import org.musicbrainz.search.index.LabelIndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.Utils;

public class LabelIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "label";
    private static final String DELETED_LABEL_MBID = "f43e252d-9ebf-4e8e-bba8-36d080756cc1";

    public LabelIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public LabelIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(LabelIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return LabelIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM label");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        PreparedStatement st = this.dbConnection.prepareStatement("SELECT count(*) FROM label WHERE id <= ? AND gid <> ?::uuid");
        st.setInt(1, maxId);
        st.setString(2, DELETED_LABEL_MBID);
        ResultSet rs = st.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public Similarity getSimilarity() {
        return new MusicbrainzSimilarity();
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("TAGS", TagHelper.constructTagQuery("label_tag", INDEX_NAME));
        this.addPreparedStatement("ALIASES", AliasHelper.constructAliasQuery(INDEX_NAME));
        this.addPreparedStatement("LABELS", "SELECT label.id, label.gid, label.name as name,  label_type.name as type, label.begin_date_year, label.begin_date_month, label.begin_date_day,   label.end_date_year, label.end_date_month, label.end_date_day, label.ended,  label.comment, label_code, lower(i.code) as country,   a1.gid as area_gid, a1.name as area_name  FROM label   LEFT JOIN label_type ON label.type = label_type.id   LEFT JOIN iso_3166_1 i on label.area=i.area  LEFT JOIN area a1 on label.area = a1.id WHERE label.id BETWEEN ? AND ?");
        this.addPreparedStatement("IPICODES", "SELECT ipi, label  FROM label_ipi   WHERE label between ? AND ?");
    }

    private Map<Integer, List<String>> loadIpiCodes(int min, int max) throws SQLException, IOException {
        HashMap<Integer, List<String>> ipiCodes = new HashMap<Integer, List<String>>();
        PreparedStatement st = this.getPreparedStatement("IPICODES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List<String> list;
            int artistId = rs.getInt(INDEX_NAME);
            if (!ipiCodes.containsKey(artistId)) {
                list = new LinkedList();
                ipiCodes.put(artistId, list);
            } else {
                list = (List)ipiCodes.get(artistId);
            }
            list.add(rs.getString("ipi"));
        }
        rs.close();
        return ipiCodes;
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        Map<Integer, List<Tag>> tags = TagHelper.loadTags(min, max, this.getPreparedStatement("TAGS"), INDEX_NAME);
        Map<Integer, List<String>> ipiCodes = this.loadIpiCodes(min, max);
        Map<Integer, Set<Alias>> aliases = AliasHelper.completeFromDbResults(min, max, this.getPreparedStatement("ALIASES"));
        PreparedStatement st = this.getPreparedStatement("LABELS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            if (rs.getString("gid").equals(DELETED_LABEL_MBID)) continue;
            indexWriter.addDocument(this.documentFromResultSet(rs, tags, ipiCodes, aliases));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, List<Tag>> tags, Map<Integer, List<String>> ipiCodes, Map<Integer, Set<Alias>> aliases) throws SQLException {
        String areaId;
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Label label = of.createLabel();
        int labelId = rs.getInt("id");
        doc.addField((IndexField)LabelIndexField.ID, labelId);
        String labelGuid = rs.getString("gid");
        doc.addField((IndexField)LabelIndexField.LABEL_ID, labelGuid);
        label.setId(labelGuid);
        String name = rs.getString("name");
        doc.addField((IndexField)LabelIndexField.LABEL, name);
        label.setName(name);
        doc.addField((IndexField)LabelIndexField.SORTNAME, name);
        label.setSortName(name);
        doc.addField((IndexField)LabelIndexField.LABEL_ACCENT, name);
        String type = rs.getString("type");
        doc.addFieldOrUnknown(LabelIndexField.TYPE, type);
        if (!Strings.isNullOrEmpty(type)) {
            label.setType(type);
        }
        String comment = rs.getString("comment");
        doc.addFieldOrNoValue(LabelIndexField.COMMENT, comment);
        if (!Strings.isNullOrEmpty(comment)) {
            label.setDisambiguation(comment);
        }
        String country = rs.getString("country");
        doc.addFieldOrUnknown(LabelIndexField.COUNTRY, country);
        if (!Strings.isNullOrEmpty(country)) {
            label.setCountry(country.toUpperCase(Locale.US));
        }
        if ((areaId = rs.getString("area_gid")) != null) {
            DefAreaElementInner area = of.createDefAreaElementInner();
            area.setId(areaId);
            String areaName = rs.getString("area_name");
            area.setName(areaName);
            doc.addFieldOrNoValue(ArtistIndexField.AREA, areaName);
            area.setSortName(areaName);
            label.setArea(area);
        } else {
            doc.addField((IndexField)ArtistIndexField.AREA, "-");
        }
        boolean ended = rs.getBoolean("ended");
        doc.addFieldOrUnknown(LabelIndexField.ENDED, Boolean.toString(ended));
        String begin = Utils.formatDate(rs.getInt("begin_date_year"), rs.getInt("begin_date_month"), rs.getInt("begin_date_day"));
        doc.addNonEmptyField(LabelIndexField.BEGIN, begin);
        String end = Utils.formatDate(rs.getInt("end_date_year"), rs.getInt("end_date_month"), rs.getInt("end_date_day"));
        doc.addNonEmptyField(LabelIndexField.END, end);
        LifeSpan lifespan = of.createLifeSpan();
        label.setLifeSpan(lifespan);
        if (!Strings.isNullOrEmpty(begin)) {
            lifespan.setBegin(begin);
        }
        if (!Strings.isNullOrEmpty(end)) {
            lifespan.setEnd(end);
        }
        lifespan.setEnded(Boolean.toString(ended));
        int labelcode = rs.getInt("label_code");
        if (labelcode > 0) {
            doc.addField((IndexField)LabelIndexField.CODE, labelcode);
            label.setLabelCode(BigInteger.valueOf(labelcode));
        } else {
            doc.addField((IndexField)LabelIndexField.CODE, "-");
        }
        if (aliases.containsKey(labelId)) {
            label.setAliasList(AliasHelper.addAliasesToDocAndConstructAliasList(of, doc, aliases, labelId, LabelIndexField.ALIAS));
        }
        if (tags.containsKey(labelId)) {
            label.setTagList(TagHelper.addTagsToDocAndConstructTagList(of, doc, tags, labelId, LabelIndexField.TAG));
        }
        if (ipiCodes.containsKey(labelId)) {
            IpiList ipiList = of.createIpiList();
            for (String ipiCode : ipiCodes.get(labelId)) {
                doc.addField((IndexField)LabelIndexField.IPI, ipiCode);
                ipiList.getIpi().add(ipiCode);
            }
            label.setIpiList(ipiList);
        }
        LabelBoostDoc.boost(labelGuid, doc);
        String store = MMDSerializer.serialize(label);
        doc.addField((IndexField)LabelIndexField.LABEL_STORE, store);
        return doc.getLuceneDocument();
    }
}

