/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.  
                  Let a thousand taggers bloom!
   
   Copyright (C) Robert Kaye 2003
   
   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: ape_meta.cpp,v 1.5 2003/08/08 21:42:37 robert Exp $

----------------------------------------------------------------------------*/
#include "../config.h"

#ifdef HAVE_LIBAPE

#include <math.h>
#include <assert.h>
#include <string>
#include <locale.h>
#include <ctype.h>
#include <map>
#include <algorithm>
#include <sstream>

#ifdef WIN32
#pragma warning(disable:4786)
#endif

using namespace std;

#include <all.h>
#include <MACLib.h>
#include <apetag.h>

#include "ape_meta.h"

// TODO: Bring this code up to date with the other tags that get written
bool Ape::write(const string &fileName, const Metadata & metadata, bool clear)
{
    char*   ptr = strrchr(fileName.c_str(), '.');
    if (ptr == NULL)
        return false;
    if (strcmp(ptr, ".ape"))
        return false;

    // TODO: Support clear option
    CAPETag    APETag( fileName.c_str(), TRUE );

	APETag.SetField( "Title", metadata.track.c_str() );
	APETag.SetField( "Artist", metadata.artist.c_str() );
	APETag.SetField( "Album", metadata.album.c_str() );

	char	tracknum[ 128 ];

	sprintf( tracknum, "%d", metadata.trackNum );

	APETag.SetField( "Track", tracknum );

	stringstream	ss;

	ss << "musicbrainz_trackid=" << metadata.trackId
	   << "|musicbrainz_trmid=" << metadata.fileTrm
	   << "|musicbrainz_artistid=" << metadata.artistId
//	   << "|musicbrainz_albumid=" << metadata.albumId;
	   ;

	APETag.SetField( "Comment", ss.str().c_str() );

	APETag.Save();

    return true;
}


bool Ape::read(const string &fileName, Metadata &metadata)
{
    char*      ptr = strrchr(fileName.c_str(), '.');

    if (ptr == NULL)
        return false;
    if (strcmp(ptr, ".ape"))
        return false;

    int					nRetVal = 0;
    IAPEDecompress*     pAPEDecompress = CreateIAPEDecompress(fileName.c_str(), &nRetVal);

    if (pAPEDecompress == NULL)
        return false;

    CAPETag*    pAPETag    = (CAPETag*)pAPEDecompress->GetInfo(APE_INFO_TAG);
    BOOL        bHasID3Tag = pAPETag->GetHasID3Tag();
    BOOL        bHasAPETag = pAPETag->GetHasAPETag();

    if ( bHasID3Tag || bHasAPETag )
    {
        if ( pAPETag->GetTagField("Title") )
            metadata.track = string( pAPETag->GetTagField("Title")->GetFieldValue() );
        if ( pAPETag->GetTagField("Artist") )
            metadata.artist = string( pAPETag->GetTagField("Artist")->GetFieldValue() );
        if ( pAPETag->GetTagField("Album") )
            metadata.album = string( pAPETag->GetTagField("Album")->GetFieldValue() );
        if ( pAPETag->GetTagField("Track") )
            metadata.trackNum = atoi(pAPETag->GetTagField("Track")->GetFieldValue());
        if ( pAPETag->GetTagField("Comment") )
        {
            CAPETagField*       comment_tag  = pAPETag->GetTagField("Comment");
            string              comment      = comment_tag->GetFieldValue();
            int					last_sep_pos = 0;

            while ( last_sep_pos != string::npos )
			{
				int		sep_pos = comment.find( "|", last_sep_pos );
				string	field   = comment.substr( last_sep_pos, sep_pos );
				int		eq_pos  = field.find( "=" );

                if ( eq_pos != string::npos )
				{
					string	name  = field.substr( 0, eq_pos );
					string	value = field.substr( eq_pos + 1 );

                    if ( name == "musicbrainz_trackid" )
                        metadata.trackId = value;
                    if ( name == "musicbrainz_trmid" )
                        metadata.fileTrm = value;
                    if ( name == "musicbrainz_artistid" )
                        metadata.artistId = value;
                    //if ( name == "musicbrainz_albumid" )
                    //    metadata.albumId = value;
                }

				if ( sep_pos != string::npos )
					last_sep_pos = sep_pos + 1;
                else
					last_sep_pos = sep_pos;
            }
        }
    }

    delete pAPEDecompress;

    metadata.fileFormat = "ape";

    return true;
}
#endif