/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.WeakAssociationBuilder;
import schemacrawler.ermodel.weakassociations.WeakAssociationsAnalyzer;
import schemacrawler.ermodel.weakassociations.WeakAssociationsAnalyzerBuilder;
import schemacrawler.ermodel.weakassociations.WeakColumnReference;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TaskRunner;
import us.fatehi.utility.scheduler.TaskRunners;
import us.fatehi.utility.string.StringFormat;

public final class WeakAssociationsCatalogLoader
extends BaseCatalogLoader {
    private static final Logger LOGGER = Logger.getLogger(WeakAssociationsCatalogLoader.class.getName());
    private static final String OPTION_WEAK_ASSOCIATIONS = "weak-associations";
    private static final String OPTION_INFER_EXTENSION_TABLES = "infer-extension-tables";

    public WeakAssociationsCatalogLoader() {
        super(new PropertyName("weakassociationsloader", "Loader for weak associations"), 3);
    }

    @Override
    public PluginCommand getCommandLineCommand() {
        PropertyName catalogLoaderName = this.getCatalogLoaderName();
        PluginCommand pluginCommand = PluginCommand.newCatalogLoaderCommand(catalogLoaderName);
        pluginCommand.addOption(OPTION_WEAK_ASSOCIATIONS, Boolean.class, "Analyzes the schema to find weak associations between tables, based on table and column naming patterns", "This can be a time consuming operation", "Optional, defaults to false");
        pluginCommand.addOption(OPTION_INFER_EXTENSION_TABLES, Boolean.class, "Infers extension tables that have similarly named primary keys, and reports them as weak associations", "Optional, defaults to false");
        return pluginCommand;
    }

    @Override
    public void loadCatalog() {
        if (!this.isLoaded()) {
            return;
        }
        LOGGER.log(Level.INFO, "Finding weak associations");
        try (TaskRunner taskRunner = TaskRunners.getTaskRunner("loadWeakAssociations", 1);){
            taskRunner.add(new TaskDefinition("retrieveWeakAssociations", () -> {
                Config config = this.getAdditionalConfiguration();
                boolean findWeakAssociations = config.getBooleanValue(OPTION_WEAK_ASSOCIATIONS, false);
                boolean inferExtensionTables = config.getBooleanValue(OPTION_INFER_EXTENSION_TABLES, false);
                if (findWeakAssociations) {
                    this.findWeakAssociations(inferExtensionTables);
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving weak associations, since this was not requested");
                }
            }));
            taskRunner.submit();
            LOGGER.log(Level.INFO, taskRunner.report());
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException("Exception retrieving weak association information", e);
        }
    }

    private void findWeakAssociations(boolean inferExtensionTables) {
        Catalog catalog = this.getCatalog();
        WeakAssociationsAnalyzerBuilder analyzerBuilder = WeakAssociationsAnalyzerBuilder.builder(catalog.getTables()).withIdMatcher();
        if (inferExtensionTables) {
            analyzerBuilder.withExtensionTableMatcher();
        }
        WeakAssociationsAnalyzer weakAssociationsAnalyzer = analyzerBuilder.build();
        Collection<WeakColumnReference> weakAssociations = weakAssociationsAnalyzer.analyzeTables();
        for (ColumnReference columnReference : weakAssociations) {
            LOGGER.log(Level.INFO, new StringFormat("Adding weak association <%s> ", columnReference));
            Column fkColumn = columnReference.getForeignKeyColumn();
            Column pkColumn = columnReference.getPrimaryKeyColumn();
            WeakAssociationBuilder builder = WeakAssociationBuilder.builder(catalog);
            builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn(fkColumn), new WeakAssociationBuilder.WeakAssociationColumn(pkColumn));
            builder.build();
        }
    }
}

