/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdui.impl;

import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.opensaml.saml.ext.saml2mdui.Keywords;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class KeywordsMarshaller
extends AbstractSAMLObjectMarshaller {
    @Override
    protected void marshallAttributes(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        Keywords words = (Keywords)xmlObject;
        if (words.getXMLLang() != null) {
            Attr attribute = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), "http://www.w3.org/XML/1998/namespace", "lang", "xml");
            attribute.setValue(words.getXMLLang());
            domElement.setAttributeNodeNS(attribute);
        }
    }

    @Override
    protected void marshallElementContent(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        Keywords words = (Keywords)xmlObject;
        List<String> keywords = words.getKeywords();
        if (keywords != null && !keywords.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String s : keywords) {
                sb.append(s);
                sb.append(' ');
            }
            ElementSupport.appendTextContent(domElement, sb.toString());
        }
    }
}

