/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.editor.lib2.view.ViewHierarchy;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyEvent;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyListener;

public final class StickyWindowSupport {
    private final JTextComponent jtc;

    StickyWindowSupport(final JTextComponent jtc) {
        this.jtc = jtc;
        ViewHierarchy.get(jtc).addViewHierarchyListener(new ViewHierarchyListener(){
            final /* synthetic */ StickyWindowSupport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void viewHierarchyChanged(ViewHierarchyEvent evt) {
                JTextComponent editor = jtc;
                Container container = editor.getParent();
                if (container instanceof JLayeredPane && evt.isChangeY()) {
                    JLayeredPane pane = (JLayeredPane)container;
                    double deltaY = evt.deltaY();
                    Component[] components = pane.getComponentsInLayer(JLayeredPane.PALETTE_LAYER);
                    Rectangle rv = null;
                    for (final Component component : components) {
                        if (!((rv = component.getBounds(rv)).getY() > evt.startY()) && !rv.contains(new Point(rv.x, (int)evt.startY())) && !rv.contains(new Point(rv.x, (int)evt.endY()))) continue;
                        final Point p = rv.getLocation();
                        p.translate(0, (int)deltaY);
                        EventQueue.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                component.setLocation(p);
                            }
                        });
                    }
                }
            }
        });
    }

    public void addWindow(JComponent window) {
        Container container = this.jtc.getParent();
        if (container instanceof JLayeredPane) {
            JLayeredPane pane = (JLayeredPane)container;
            pane.add((Component)window, JLayeredPane.PALETTE_LAYER);
            window.setVisible(true);
        }
    }

    @NonNull
    public Point convertPoint(Point aPoint) {
        Point value = aPoint;
        Container container = this.jtc.getParent();
        if (container instanceof JLayeredPane) {
            JLayeredPane pane = (JLayeredPane)container;
            value = SwingUtilities.convertPoint(pane.getRootPane(), value, pane);
        }
        return value;
    }

    public void removeWindow(JComponent window) {
        Container container = this.jtc.getParent();
        if (container instanceof JLayeredPane) {
            JLayeredPane pane = (JLayeredPane)container;
            pane.remove(window);
            pane.repaint(window.getBounds());
        }
    }
}

