/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsFromGroup;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.BreakpointsExpandableGroup;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.OutlineComboBox;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ActionsPanel
extends JPanel {
    private static final String DEFAULT_SUSPEND_ACTION = "default.suspend.action";
    private JPDABreakpoint breakpoint;
    private int defaultSuspendAction;
    private int checkedSuspendAction;
    private Preferences preferences = NbPreferences.forModule(JPDABreakpoint.class).node("debugging");
    private static final Object NONE_BREAKPOINT_GROUP = new NoneBreakpointGroup();
    private JComboBox cbSuspend;
    private JPanel checkBoxPanel;
    private JCheckBox defaultActionCheckBox;
    private JCheckBox disableGroupCheckBox;
    private JComboBox disableGroupComboBox;
    private JLabel disableGroupLabel;
    private JCheckBox enableGroupCheckBox;
    private JComboBox enableGroupComboBox;
    private JLabel enableGroupLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField tfPrintText;

    public ActionsPanel(JPDABreakpoint b) {
        this.breakpoint = b;
        this.initComponents();
        ResourceBundle bundle = NbBundle.getBundle(ActionsPanel.class);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultActionCheckBox, (String)bundle.getString("LBL_Use_As_Default_Option"));
        this.defaultActionCheckBox.setToolTipText(bundle.getString("TTT_Use_As_Default_Option"));
        this.checkBoxPanel.setPreferredSize(this.defaultActionCheckBox.getPreferredSize());
        this.cbSuspend.addItem(bundle.getString("LBL_CB_Actions_Panel_Suspend_None"));
        this.cbSuspend.addItem(bundle.getString("LBL_CB_Actions_Panel_Suspend_Current"));
        this.cbSuspend.addItem(bundle.getString("LBL_CB_Actions_Panel_Suspend_All"));
        switch (b.getSuspend()) {
            case 0: {
                this.cbSuspend.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.cbSuspend.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.cbSuspend.setSelectedIndex(2);
            }
        }
        this.checkedSuspendAction = this.defaultSuspendAction = this.preferences.getInt(DEFAULT_SUSPEND_ACTION, 1);
        if (this.defaultSuspendAction == this.cbSuspend.getSelectedIndex()) {
            this.defaultActionCheckBox.setVisible(false);
        } else {
            this.defaultActionCheckBox.setVisible(true);
            this.defaultActionCheckBox.setSelected(false);
        }
        if (b.getPrintText() != null) {
            this.tfPrintText.setText(b.getPrintText());
        }
        this.tfPrintText.setPreferredSize(new Dimension(30 * this.tfPrintText.getFontMetrics(this.tfPrintText.getFont()).charWidth('W'), this.tfPrintText.getPreferredSize().height));
        this.tfPrintText.setCaretPosition(0);
        this.enableGroupCheckBox.setVisible(false);
        this.disableGroupCheckBox.setVisible(false);
        Object[] groups = ActionsPanel.getGroups();
        Set breakpointsToEnable = this.breakpoint.getBreakpointsToEnable();
        Set breakpointsToDisable = this.breakpoint.getBreakpointsToDisable();
        BreakpointsFromGroup bfgToEnable = null;
        BreakpointsFromGroup bfgToDisable = null;
        if (breakpointsToEnable instanceof BreakpointsFromGroup) {
            bfgToEnable = (BreakpointsFromGroup)breakpointsToEnable;
        }
        if (breakpointsToDisable instanceof BreakpointsFromGroup) {
            bfgToDisable = (BreakpointsFromGroup)breakpointsToDisable;
        }
        this.fillGroups((OutlineComboBox)this.enableGroupComboBox, groups, bfgToEnable);
        this.fillGroups((OutlineComboBox)this.disableGroupComboBox, groups, bfgToDisable);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbSuspend = new JComboBox();
        this.checkBoxPanel = new JPanel();
        this.defaultActionCheckBox = new JCheckBox();
        this.enableGroupCheckBox = new JCheckBox();
        this.enableGroupLabel = new JLabel();
        this.enableGroupComboBox = new OutlineComboBox();
        this.disableGroupCheckBox = new JCheckBox();
        this.disableGroupLabel = new JLabel();
        this.disableGroupComboBox = new OutlineComboBox();
        this.jLabel2 = new JLabel();
        this.tfPrintText = new JTextField();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle");
        this.setBorder(BorderFactory.createTitledBorder(bundle.getString("L_Actions_Panel_BorderTitle")));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.cbSuspend);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)bundle.getString("L_Actions_Panel_Suspend"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(bundle.getString("ASCD_L_Actions_Panel_Suspend"));
        this.cbSuspend.setToolTipText(bundle.getString("TTT_CB_Actions_Panel_Suspend"));
        this.cbSuspend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.cbSuspendActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbSuspend, gridBagConstraints);
        this.cbSuspend.getAccessibleContext().setAccessibleDescription(bundle.getString("ASCD_CB_Actions_Panel_Suspend"));
        this.checkBoxPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.defaultActionCheckBox, (String)"jCheckBox1");
        this.defaultActionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.defaultActionCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.checkBoxPanel.add((Component)this.defaultActionCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.checkBoxPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableGroupCheckBox, (String)NbBundle.getMessage(ActionsPanel.class, (String)"MSG_EnableGroup"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.enableGroupCheckBox, gridBagConstraints);
        this.enableGroupLabel.setLabelFor(this.enableGroupComboBox);
        Mnemonics.setLocalizedText((JLabel)this.enableGroupLabel, (String)NbBundle.getMessage(ActionsPanel.class, (String)"MSG_EnableGroup"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.enableGroupLabel, gridBagConstraints);
        this.enableGroupComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.enableGroupComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.disableGroupCheckBox, (String)NbBundle.getMessage(ActionsPanel.class, (String)"MSG_DisableGroup"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.disableGroupCheckBox, gridBagConstraints);
        this.disableGroupLabel.setLabelFor(this.disableGroupComboBox);
        Mnemonics.setLocalizedText((JLabel)this.disableGroupLabel, (String)NbBundle.getMessage(ActionsPanel.class, (String)"MSG_DisableGroup"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.disableGroupLabel, gridBagConstraints);
        this.disableGroupComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.add((Component)this.disableGroupComboBox, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tfPrintText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)bundle.getString("L_Actions_Panel_Print_Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionsPanel.class, (String)"ACSD_PrintText"));
        this.tfPrintText.setToolTipText(bundle.getString("TTT_TF_Actions_Panel_Print_Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.tfPrintText, gridBagConstraints);
        this.tfPrintText.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TF_Actions_Panel_Print_Text"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionsPanel.class, (String)"ACSD_Actions"));
    }

    private void defaultActionCheckBoxActionPerformed(ActionEvent evt) {
        this.checkedSuspendAction = this.cbSuspend.getSelectedIndex();
    }

    private void cbSuspendActionPerformed(ActionEvent evt) {
        int selectedIndex = this.cbSuspend.getSelectedIndex();
        if (this.defaultSuspendAction == selectedIndex) {
            this.defaultActionCheckBox.setVisible(false);
        } else {
            this.defaultActionCheckBox.setVisible(true);
            this.defaultActionCheckBox.setSelected(false);
        }
        this.checkedSuspendAction = this.defaultSuspendAction;
    }

    public void ok() {
        String printText = this.tfPrintText.getText();
        if (printText.trim().length() > 0) {
            this.breakpoint.setPrintText(printText.trim());
        } else {
            this.breakpoint.setPrintText(null);
        }
        switch (this.cbSuspend.getSelectedIndex()) {
            case 0: {
                this.breakpoint.setSuspend(0);
                break;
            }
            case 1: {
                this.breakpoint.setSuspend(1);
                break;
            }
            case 2: {
                this.breakpoint.setSuspend(2);
            }
        }
        if (this.checkedSuspendAction != this.defaultSuspendAction) {
            this.preferences.putInt(DEFAULT_SUSPEND_ACTION, this.checkedSuspendAction);
        }
        Object breakpointsToEnableGroup = this.enableGroupComboBox.getSelectedItem();
        this.breakpoint.setBreakpointsToEnable(ActionsPanel.createBreakpointsSet(breakpointsToEnableGroup));
        Object breakpointsToDisableGroup = this.disableGroupComboBox.getSelectedItem();
        this.breakpoint.setBreakpointsToDisable(ActionsPanel.createBreakpointsSet(breakpointsToDisableGroup));
    }

    private static Set<Breakpoint> createBreakpointsSet(Object selectedGroup) {
        if (selectedGroup == null || selectedGroup == NONE_BREAKPOINT_GROUP) {
            return Collections.emptySet();
        }
        BreakpointsFromGroup.TestGroupProperties tgp = ActionsPanel.createTestProperties(selectedGroup);
        if (tgp != null) {
            return new BreakpointsFromGroup(tgp);
        }
        String customGroup = (String)selectedGroup;
        if (!(customGroup = customGroup.trim()).isEmpty()) {
            return new BreakpointsFromGroup(customGroup);
        }
        return Collections.emptySet();
    }

    private static BreakpointsFromGroup.TestGroupProperties createTestProperties(Object group) {
        if (group instanceof BreakpointsExpandableGroup.FileItem) {
            return new BreakpointsFromGroup.TestGroupProperties(((BreakpointsExpandableGroup.FileItem)group).getFileObject());
        }
        if (group instanceof BreakpointsExpandableGroup.ProjectItem) {
            return new BreakpointsFromGroup.TestGroupProperties(((BreakpointsExpandableGroup.ProjectItem)group).getProject());
        }
        if (group instanceof BreakpointsExpandableGroup.TypeItem) {
            return new BreakpointsFromGroup.TestGroupProperties(((BreakpointsExpandableGroup.TypeItem)group).getType());
        }
        return null;
    }

    private void fillGroupNames(OutlineComboBox cb, Object[] groupNames) {
        cb.setItems(groupNames);
        cb.setSelectedIndex(0);
    }

    private Object[] fillGroups(OutlineComboBox cb, Object[] groups, BreakpointsFromGroup groupToSelect) {
        int index = groups.length - 3;
        BreakpointsExpandableGroup.FilesGroup fg = new BreakpointsExpandableGroup.FilesGroup();
        BreakpointsExpandableGroup.ProjectsGroup pg = new BreakpointsExpandableGroup.ProjectsGroup();
        BreakpointsExpandableGroup.TypesGroup tg = new BreakpointsExpandableGroup.TypesGroup();
        groups[index++] = fg;
        groups[index++] = pg;
        groups[index++] = tg;
        cb.setItems(groups);
        if (groupToSelect == null) {
            cb.setSelectedIndex(0);
        } else {
            String groupName = groupToSelect.getGroupName();
            if (groupName != null) {
                cb.setSelectedItem(groupName);
            } else {
                String type;
                Project project;
                BreakpointsFromGroup.TestGroupProperties tgp = groupToSelect.getTestGroupProperties();
                FileObject fo = tgp.getFileObject();
                if (fo != null) {
                    BreakpointsExpandableGroup.FileItem[] items;
                    for (BreakpointsExpandableGroup.FileItem fi : items = (BreakpointsExpandableGroup.FileItem[])fg.getItems()) {
                        if (!fo.equals(fi.getFileObject())) continue;
                        cb.getModel().setSelectedItem(fg);
                        cb.setSelectedItem(fi);
                        break;
                    }
                }
                if ((project = tgp.getProject()) != null) {
                    BreakpointsExpandableGroup.ProjectItem[] items;
                    for (BreakpointsExpandableGroup.ProjectItem pi : items = (BreakpointsExpandableGroup.ProjectItem[])pg.getItems()) {
                        if (!project.equals((Object)pi.getProject())) continue;
                        cb.getModel().setSelectedItem(pg);
                        cb.setSelectedItem(pi);
                        break;
                    }
                }
                if ((type = tgp.getType()) != null) {
                    BreakpointsExpandableGroup.TypeItem[] items;
                    for (BreakpointsExpandableGroup.TypeItem ti : items = (BreakpointsExpandableGroup.TypeItem[])tg.getItems()) {
                        if (!type.equals(ti.getType())) continue;
                        cb.getModel().setSelectedItem(tg);
                        cb.setSelectedItem(ti);
                        break;
                    }
                }
            }
        }
        return groups;
    }

    private static String[] getGroupNames() {
        TreeSet<String> groupNamesSorted = new TreeSet<String>();
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bs.length; ++i) {
            String gn = bs[i].getGroupName();
            groupNamesSorted.add(gn);
        }
        groupNamesSorted.remove("");
        ArrayList<String> groupNames = new ArrayList<String>(groupNamesSorted);
        groupNames.add(0, NbBundle.getMessage(ActionsPanel.class, (String)"LBL_NoneBreakpointGroup"));
        return groupNames.toArray(new String[0]);
    }

    private static Object[] getGroups() {
        TreeSet<String> groupNamesSorted = new TreeSet<String>();
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bs.length; ++i) {
            String gn = bs[i].getGroupName();
            groupNamesSorted.add(gn);
        }
        groupNamesSorted.remove("");
        Object[] groups = new Object[1 + groupNamesSorted.size() + 3];
        groups[0] = NONE_BREAKPOINT_GROUP;
        int i = 1;
        for (String gn : groupNamesSorted) {
            groups[i++] = gn;
        }
        return groups;
    }

    private static final class NoneBreakpointGroup {
        private NoneBreakpointGroup() {
        }

        public String toString() {
            return NbBundle.getMessage(ActionsPanel.class, (String)"LBL_NoneBreakpointGroup");
        }

        public static Object valueOf(String newString) {
            if (newString.isEmpty() || NbBundle.getMessage(ActionsPanel.class, (String)"LBL_NoneBreakpointGroup").equals(newString)) {
                return NONE_BREAKPOINT_GROUP;
            }
            return newString;
        }
    }
}

