/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Bundle;
import org.netbeans.api.debugger.DebuggerManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class Properties {
    private static final Logger LOG = Logger.getLogger(Properties.class.getName());
    private static Properties defaultProperties;

    public static synchronized Properties getDefault() {
        if (defaultProperties == null) {
            defaultProperties = new PropertiesImpl();
        }
        return defaultProperties;
    }

    public abstract String getString(String var1, String var2);

    public abstract void setString(String var1, String var2);

    public abstract int getInt(String var1, int var2);

    public abstract void setInt(String var1, int var2);

    public abstract char getChar(String var1, char var2);

    public abstract void setChar(String var1, char var2);

    public abstract float getFloat(String var1, float var2);

    public abstract void setFloat(String var1, float var2);

    public abstract long getLong(String var1, long var2);

    public abstract void setLong(String var1, long var2);

    public abstract double getDouble(String var1, double var2);

    public abstract void setDouble(String var1, double var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract void setBoolean(String var1, boolean var2);

    public abstract byte getByte(String var1, byte var2);

    public abstract void setByte(String var1, byte var2);

    public abstract short getShort(String var1, short var2);

    public abstract void setShort(String var1, short var2);

    public abstract Object getObject(String var1, Object var2);

    public abstract void setObject(String var1, Object var2);

    public abstract Object[] getArray(String var1, Object[] var2);

    public abstract void setArray(String var1, Object[] var2);

    public abstract Collection getCollection(String var1, Collection var2);

    public abstract void setCollection(String var1, Collection var2);

    public abstract Map getMap(String var1, Map var2);

    public abstract void setMap(String var1, Map var2);

    public abstract Properties getProperties(String var1);

    public void addPropertyChangeListener(PropertyChangeListener l) {
        throw new UnsupportedOperationException("Unsupported listening on " + String.valueOf(this.getClass()) + " properties.");
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        throw new UnsupportedOperationException("Unsupported listening on " + String.valueOf(this.getClass()) + " properties.");
    }

    static class PropertiesImpl
    extends Properties {
        private static final Object BAD_OBJECT = new Object();
        private static final String BAD_STRING = "";
        private static final Map BAD_MAP = new HashMap();
        private static final Collection BAD_COLLECTION = new ArrayList();
        private static final Object[] BAD_ARRAY = new Object[0];
        private final Map<String, Reference<Properties>> childProperties = new HashMap<String, Reference<Properties>>();
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final Map<PropertyChangeListener, Properties> propertiesHeldByListener = new WeakHashMap<PropertyChangeListener, Properties>();
        ServicesHolder<Reader> readers = new ReaderHolder();
        ServicesHolder<Initializer> initializers = new InitializerHolder();
        private final PrimitiveRegister impl = new PrimitiveRegister();
        private static ClassLoader classLoader;

        PropertiesImpl() {
        }

        private <T> T getInitialValue(String propertyName, Class<T> clazz) {
            Initializer initializer = this.initializers.find(propertyName);
            if (initializer != null) {
                Object value = initializer.getDefaultPropertyValue(propertyName);
                if (value != null && !clazz.isAssignableFrom(value.getClass())) {
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("Value (" + String.valueOf(value) + ") of a bad type (" + String.valueOf(value.getClass()) + ") returned by " + String.valueOf(initializer) + " for property '" + propertyName + "'. It can not be cast to " + String.valueOf(clazz)));
                    value = null;
                }
                return (T)value;
            }
            return null;
        }

        @Override
        public String getString(String propertyName, String defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                String initialValue = this.getInitialValue(propertyName, String.class);
                if (initialValue == null) {
                    initialValue = defaultValue;
                }
                return initialValue;
            }
            if (value.equals("# null")) {
                return null;
            }
            if (!value.startsWith("\"")) {
                LOG.config("Can not read string " + value + ".");
                return defaultValue;
            }
            return value.substring(1, value.length() - 1);
        }

        @Override
        public void setString(String propertyName, String value) {
            if (value != null) {
                this.impl.setProperty(propertyName, "\"" + value + "\"");
            } else {
                this.impl.setProperty(propertyName, "# null");
            }
            this.pcs.firePropertyChange(propertyName, null, value);
        }

        @Override
        public int getInt(String propertyName, int defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                Integer initialValue = this.getInitialValue(propertyName, Integer.class);
                if (initialValue == null) {
                    initialValue = defaultValue;
                }
                return initialValue;
            }
            try {
                int val = Integer.parseInt(value);
                return val;
            }
            catch (NumberFormatException nfex) {
                return defaultValue;
            }
        }

        @Override
        public void setInt(String propertyName, int value) {
            this.impl.setProperty(propertyName, Integer.toString(value));
            this.pcs.firePropertyChange(propertyName, null, (Object)value);
        }

        @Override
        public char getChar(String propertyName, char defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                Character initialValue = this.getInitialValue(propertyName, Character.class);
                if (initialValue == null) {
                    initialValue = Character.valueOf(defaultValue);
                }
                return initialValue.charValue();
            }
            char val = value.charAt(0);
            return val;
        }

        @Override
        public void setChar(String propertyName, char value) {
            this.impl.setProperty(propertyName, Character.toString(value));
            this.pcs.firePropertyChange(propertyName, null, Character.valueOf(value));
        }

        @Override
        public float getFloat(String propertyName, float defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                Float initialValue = this.getInitialValue(propertyName, Float.class);
                if (initialValue == null) {
                    initialValue = Float.valueOf(defaultValue);
                }
                return initialValue.floatValue();
            }
            try {
                float val = Float.parseFloat(value);
                return val;
            }
            catch (NumberFormatException nfex) {
                return defaultValue;
            }
        }

        @Override
        public void setFloat(String propertyName, float value) {
            this.impl.setProperty(propertyName, Float.toString(value));
            this.pcs.firePropertyChange(propertyName, null, Float.valueOf(value));
        }

        @Override
        public long getLong(String propertyName, long defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                Long initialValue = this.getInitialValue(propertyName, Long.class);
                if (initialValue == null) {
                    initialValue = defaultValue;
                }
                return initialValue;
            }
            try {
                long val = Long.parseLong(value);
                return val;
            }
            catch (NumberFormatException nfex) {
                return defaultValue;
            }
        }

        @Override
        public void setLong(String propertyName, long value) {
            this.impl.setProperty(propertyName, Long.toString(value));
            this.pcs.firePropertyChange(propertyName, null, value);
        }

        @Override
        public double getDouble(String propertyName, double defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                Double initialValue = this.getInitialValue(propertyName, Double.class);
                if (initialValue == null) {
                    initialValue = defaultValue;
                }
                return initialValue;
            }
            try {
                double val = Double.parseDouble(value);
                return val;
            }
            catch (NumberFormatException nfex) {
                return defaultValue;
            }
        }

        @Override
        public void setDouble(String propertyName, double value) {
            this.impl.setProperty(propertyName, Double.toString(value));
            this.pcs.firePropertyChange(propertyName, null, value);
        }

        @Override
        public boolean getBoolean(String propertyName, boolean defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                Boolean initialValue = this.getInitialValue(propertyName, Boolean.class);
                if (initialValue == null) {
                    initialValue = defaultValue;
                }
                return initialValue;
            }
            boolean val = value.equals("true");
            return val;
        }

        @Override
        public void setBoolean(String propertyName, boolean value) {
            this.impl.setProperty(propertyName, value ? "true" : "false");
            this.pcs.firePropertyChange(propertyName, null, (Object)value);
        }

        @Override
        public byte getByte(String propertyName, byte defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                Byte initialValue = this.getInitialValue(propertyName, Byte.class);
                if (initialValue == null) {
                    initialValue = defaultValue;
                }
                return initialValue;
            }
            try {
                byte val = Byte.parseByte(value);
                return val;
            }
            catch (NumberFormatException nfex) {
                return defaultValue;
            }
        }

        @Override
        public void setByte(String propertyName, byte value) {
            this.impl.setProperty(propertyName, Byte.toString(value));
            this.pcs.firePropertyChange(propertyName, null, (Object)value);
        }

        @Override
        public short getShort(String propertyName, short defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                Short initialValue = this.getInitialValue(propertyName, Short.class);
                if (initialValue == null) {
                    initialValue = defaultValue;
                }
                return initialValue;
            }
            try {
                short val = Short.parseShort(value);
                return val;
            }
            catch (NumberFormatException nfex) {
                return defaultValue;
            }
        }

        @Override
        public void setShort(String propertyName, short value) {
            this.impl.setProperty(propertyName, Short.toString(value));
            this.pcs.firePropertyChange(propertyName, null, (Object)value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getObject(String propertyName, Object defaultValue) {
            try {
                Reader r;
                this.impl.lockRead(propertyName);
                String typeID = this.impl.getProperty(propertyName, null);
                if (typeID == null) {
                    Object initialValue = this.getInitialValue(propertyName, Object.class);
                    if (initialValue == null) {
                        initialValue = defaultValue;
                    }
                    Object object = initialValue;
                    return object;
                }
                if (typeID.equals("# null")) {
                    Object initialValue = null;
                    return initialValue;
                }
                if (!typeID.startsWith("# ")) {
                    if (typeID.startsWith("\"")) {
                        String s = this.getString(propertyName, BAD_STRING);
                        if (s == BAD_STRING) {
                            Object object = defaultValue;
                            return object;
                        }
                        String string = s;
                        return string;
                    }
                    LOG.config("Can not read object " + typeID + ". No reader registered for type " + typeID + ".");
                    Object s = defaultValue;
                    return s;
                }
                typeID = typeID.substring(2);
                Class<?> c = null;
                try {
                    c = Class.forName(typeID, true, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (c != null) {
                    if (Map.class.isAssignableFrom(c)) {
                        Map m = this.getMap(propertyName, BAD_MAP);
                        if (m == BAD_MAP) {
                            Object object = defaultValue;
                            return object;
                        }
                        Map map = m;
                        return map;
                    }
                    if (Object[].class.isAssignableFrom(c)) {
                        Object[] os = this.getArray(propertyName, BAD_ARRAY);
                        if (os == BAD_ARRAY) {
                            Object object = defaultValue;
                            return object;
                        }
                        Object[] objectArray = os;
                        return objectArray;
                    }
                    if (Collection.class.isAssignableFrom(c)) {
                        Collection co = this.getCollection(propertyName, BAD_COLLECTION);
                        if (co == BAD_COLLECTION) {
                            Object object = defaultValue;
                            return object;
                        }
                        Collection collection = co;
                        return collection;
                    }
                }
                if ((r = this.readers.find(typeID)) == null) {
                    LOG.config("Can not read object. No reader registered for type " + typeID + ".");
                    Object object = defaultValue;
                    return object;
                }
                Object object = r.read(typeID, this.getProperties(propertyName));
                return object;
            }
            finally {
                this.impl.unLockRead(propertyName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setObject(String propertyName, Object value) {
            try {
                this.impl.lockWrite(propertyName);
                if (value == null) {
                    this.impl.setProperty(propertyName, "# null");
                } else if (value instanceof String) {
                    this.setString(propertyName, (String)value);
                } else if (value instanceof Map) {
                    this.setMap(propertyName, (Map)value);
                } else if (value instanceof Collection) {
                    this.setCollection(propertyName, (Collection)value);
                } else if (value instanceof Object[]) {
                    this.setArray(propertyName, (Object[])value);
                } else {
                    Reader r = this.readers.find(value.getClass().getName());
                    if (r == null) {
                        LOG.config("Can not write object " + String.valueOf(value));
                        return;
                    }
                    r.write(value, this.getProperties(propertyName));
                    this.impl.setProperty(propertyName, "# " + value.getClass().getName());
                }
            }
            finally {
                this.impl.unLockWrite(propertyName);
            }
            this.pcs.firePropertyChange(propertyName, null, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] getArray(String propertyName, Object[] defaultValue) {
            try {
                Object[] os;
                this.impl.lockRead(propertyName);
                String arrayType = this.impl.getProperty(propertyName + ".array_type", null);
                if (arrayType == null) {
                    Object[] initialValue = this.getInitialValue(propertyName, Object[].class);
                    if (initialValue == null) {
                        initialValue = defaultValue;
                    }
                    Object[] objectArray = initialValue;
                    return objectArray;
                }
                Properties p = this.getProperties(propertyName);
                int l = p.getInt("length", -1);
                if (l < 0) {
                    Object[] objectArray = defaultValue;
                    return objectArray;
                }
                boolean fixArrayType = false;
                ClassNotFoundException arrayTypeNotFoundEx = null;
                try {
                    os = (Object[])Array.newInstance(PropertiesImpl.getClassLoader().loadClass(arrayType), l);
                }
                catch (ClassNotFoundException ex) {
                    arrayTypeNotFoundEx = ex;
                    os = new Object[l];
                    fixArrayType = true;
                }
                Class<?> aType = null;
                for (int i = 0; i < l; ++i) {
                    Object o = p.getObject(BAD_STRING + i, BAD_OBJECT);
                    if (o == BAD_OBJECT) {
                        Object[] objectArray = defaultValue;
                        return objectArray;
                    }
                    os[i] = o;
                    if (!fixArrayType || o == null) continue;
                    Class<?> oType = o.getClass();
                    if (aType == null) {
                        aType = oType;
                        continue;
                    }
                    if (aType == oType) continue;
                    fixArrayType = false;
                    aType = null;
                }
                if (fixArrayType && aType != null) {
                    Object[] newOS = (Object[])Array.newInstance(aType, l);
                    System.arraycopy(os, 0, newOS, 0, l);
                    os = newOS;
                } else if (arrayTypeNotFoundEx != null) {
                    Exceptions.printStackTrace((Throwable)arrayTypeNotFoundEx);
                }
                Object[] objectArray = os;
                return objectArray;
            }
            finally {
                this.impl.unLockRead(propertyName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setArray(String propertyName, Object[] value) {
            try {
                this.impl.lockWrite(propertyName);
                this.impl.setProperty(propertyName, "# array");
                this.impl.setProperty(propertyName + ".array_type", value.getClass().getComponentType().getName());
                Properties p = this.getProperties(propertyName);
                int k = value.length;
                p.setInt("length", k);
                for (int i = 0; i < k; ++i) {
                    p.setObject(BAD_STRING + i, value[i]);
                }
            }
            finally {
                this.impl.unLockWrite(propertyName);
            }
            this.pcs.firePropertyChange(propertyName, null, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection getCollection(String propertyName, Collection defaultValue) {
            try {
                Collection c;
                this.impl.lockRead(propertyName);
                String typeID = this.impl.getProperty(propertyName, null);
                if (typeID == null) {
                    Collection initialValue = this.getInitialValue(propertyName, Collection.class);
                    if (initialValue == null) {
                        initialValue = defaultValue;
                    }
                    Collection collection = initialValue;
                    return collection;
                }
                if (!typeID.startsWith("# ")) {
                    Collection initialValue = defaultValue;
                    return initialValue;
                }
                try {
                    c = (Collection)Class.forName(typeID.substring(2)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException ex) {
                    LOG.log(Level.WARNING, ex.getLocalizedMessage(), ex);
                    Collection collection = defaultValue;
                    this.impl.unLockRead(propertyName);
                    return collection;
                }
                Properties p = this.getProperties(propertyName);
                int k = p.getInt("length", 0);
                for (int i = 0; i < k; ++i) {
                    Object o = p.getObject(BAD_STRING + i, BAD_OBJECT);
                    if (o == BAD_OBJECT) {
                        Collection collection = defaultValue;
                        return collection;
                    }
                    c.add(o);
                }
                Collection collection = c;
                return collection;
            }
            finally {
                this.impl.unLockRead(propertyName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCollection(String propertyName, Collection value) {
            try {
                this.impl.lockWrite(propertyName);
                if (value == null) {
                    this.impl.setProperty(propertyName, null);
                } else {
                    this.impl.setProperty(propertyName, "# " + value.getClass().getName());
                    Properties p = this.getProperties(propertyName);
                    Iterator it = value.iterator();
                    int i = 0;
                    p.setInt("length", value.size());
                    while (it.hasNext()) {
                        p.setObject(BAD_STRING + i, it.next());
                        ++i;
                    }
                }
            }
            finally {
                this.impl.unLockWrite(propertyName);
            }
            this.pcs.firePropertyChange(propertyName, null, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map getMap(String propertyName, Map defaultValue) {
            try {
                Map m;
                this.impl.lockRead(propertyName);
                String typeID = this.impl.getProperty(propertyName, null);
                if (typeID == null) {
                    Map initialValue = this.getInitialValue(propertyName, Map.class);
                    if (initialValue == null) {
                        initialValue = defaultValue;
                    }
                    Map map = initialValue;
                    return map;
                }
                if (!typeID.startsWith("# ")) {
                    Map initialValue = defaultValue;
                    return initialValue;
                }
                try {
                    m = (Map)Class.forName(typeID.substring(2)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException ex) {
                    LOG.log(Level.WARNING, ex.getLocalizedMessage(), ex);
                    Map map = defaultValue;
                    this.impl.unLockRead(propertyName);
                    return map;
                }
                Properties p = this.getProperties(propertyName);
                int k = p.getInt("length", 0);
                for (int i = 0; i < k; ++i) {
                    Object key = p.getObject(i + "-key", BAD_OBJECT);
                    if (key == BAD_OBJECT) {
                        Map map = defaultValue;
                        return map;
                    }
                    Object value = p.getObject(i + "-value", BAD_OBJECT);
                    if (value == BAD_OBJECT) {
                        Map map = defaultValue;
                        return map;
                    }
                    m.put(key, value);
                }
                Map map = m;
                return map;
            }
            finally {
                this.impl.unLockRead(propertyName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMap(String propertyName, Map value) {
            try {
                this.impl.lockWrite(propertyName);
                if (value == null) {
                    this.impl.setProperty(propertyName, null);
                } else {
                    this.impl.setProperty(propertyName, "# " + value.getClass().getName());
                    Properties p = this.getProperties(propertyName);
                    Iterator it = value.entrySet().iterator();
                    int i = 0;
                    p.setInt("length", value.size());
                    while (it.hasNext()) {
                        Map.Entry e = it.next();
                        p.setObject(i + "-key", e.getKey());
                        p.setObject(i + "-value", e.getValue());
                        ++i;
                    }
                }
            }
            finally {
                this.impl.unLockWrite(propertyName);
            }
            this.pcs.firePropertyChange(propertyName, null, value);
        }

        public void unset(String propertyName) {
            this.impl.removeProperty(propertyName);
            this.pcs.firePropertyChange(propertyName, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Properties getProperties(String propertyName) {
            Map<String, Reference<Properties>> map = this.childProperties;
            synchronized (map) {
                Properties p;
                Reference<Properties> propRef = this.childProperties.get(propertyName);
                if (propRef != null && (p = propRef.get()) != null) {
                    return p;
                }
                p = new DelegatingProperties(this, propertyName);
                propRef = new WeakReference<Properties>(p);
                this.childProperties.put(propertyName, propRef);
                return p;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
            Map<PropertyChangeListener, Properties> map = this.propertiesHeldByListener;
            synchronized (map) {
                this.propertiesHeldByListener.put(l, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
            Map<PropertyChangeListener, Properties> map = this.propertiesHeldByListener;
            synchronized (map) {
                this.propertiesHeldByListener.remove(l);
            }
        }

        private static ClassLoader getClassLoader() {
            if (classLoader == null) {
                classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            }
            return classLoader;
        }

        private static final class ReaderHolder
        extends ServicesHolder<Reader> {
            private final DefaultReader defaultReader = new DefaultReader();

            public ReaderHolder() {
                super(Reader.class);
            }

            @Override
            protected void initServices() {
                this.registerService(this.defaultReader);
            }

            @Override
            protected void registerService(Reader r) {
                String[] ns = r.getSupportedClassNames();
                int jj = ns.length;
                for (int j = 0; j < jj; ++j) {
                    this.register.put(ns[j], r);
                }
            }

            @Override
            protected void unregisterService(Reader r) {
                if (r == this.defaultReader) {
                    return;
                }
                String[] ns = r.getSupportedClassNames();
                int jj = ns.length;
                for (int j = 0; j < jj; ++j) {
                    this.register.remove(ns[j]);
                }
            }

            @Override
            public synchronized Reader find(String typeID) {
                Class<?> c;
                Reader r = (Reader)super.find(typeID);
                if (r != null) {
                    return r;
                }
                try {
                }
                catch (ClassNotFoundException e) {
                    LOG.log(Level.WARNING, e.getLocalizedMessage(), e);
                    return null;
                }
                for (c = PropertiesImpl.getClassLoader().loadClass(typeID); c != null && this.register.get(c.getName()) == null; c = c.getSuperclass()) {
                }
                if (c != null) {
                    r = (Reader)this.register.get(c.getName());
                }
                return r;
            }
        }

        private static abstract class ServicesHolder<T> {
            private Class<T> clazz;
            private List<? extends T> servicesList;
            protected HashMap<String, T> register;

            public ServicesHolder(Class<T> clazz) {
                this.clazz = clazz;
            }

            protected void initServices() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void init() {
                this.register = new HashMap();
                this.initServices();
                final List<T> list = DebuggerManager.getDebuggerManager().lookup(null, this.clazz);
                this.servicesList = list;
                List<T> list2 = list;
                synchronized (list2) {
                    for (T s : list) {
                        this.registerService(s);
                    }
                }
                ((Customizer)((Object)list)).addPropertyChangeListener(new PropertyChangeListener(){
                    final /* synthetic */ ServicesHolder this$0;
                    {
                        this.this$0 = this$0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        ServicesHolder servicesHolder = this.this$0;
                        synchronized (servicesHolder) {
                            HashSet registeredServices = new HashSet(this.this$0.register.values());
                            List list2 = list;
                            synchronized (list2) {
                                for (Object s : list) {
                                    if (registeredServices.remove(s)) continue;
                                    this.this$0.registerService(s);
                                }
                            }
                            for (Object s : registeredServices) {
                                this.this$0.unregisterService(s);
                            }
                        }
                    }
                });
                ((Customizer)((Object)list)).setObject("load first");
                ((Customizer)((Object)list)).setObject("unload last");
            }

            protected abstract void registerService(T var1);

            protected abstract void unregisterService(T var1);

            public synchronized T find(String name) {
                if (this.register == null) {
                    this.init();
                }
                return this.register.get(name);
            }
        }

        private static final class InitializerHolder
        extends ServicesHolder<Initializer> {
            public InitializerHolder() {
                super(Initializer.class);
            }

            @Override
            protected void registerService(Initializer i) {
                String[] ns = i.getSupportedPropertyNames();
                int jj = ns.length;
                for (int j = 0; j < jj; ++j) {
                    this.register.put(ns[j], i);
                }
            }

            @Override
            protected void unregisterService(Initializer i) {
                String[] ns = i.getSupportedPropertyNames();
                int jj = ns.length;
                for (int j = 0; j < jj; ++j) {
                    this.register.remove(ns[j]);
                }
            }
        }

        private static class DefaultReader
        implements Reader {
            private static final String[] classNames = new String[]{Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName()};
            private static final String propertyName = "primitiveWrapper";

            private DefaultReader() {
            }

            @Override
            public String[] getSupportedClassNames() {
                return classNames;
            }

            @Override
            public Object read(String className, Properties properties) {
                if (classNames[0].equals(className)) {
                    return properties.getBoolean(propertyName, false);
                }
                if (classNames[1].equals(className)) {
                    return properties.getByte(propertyName, (byte)0);
                }
                if (classNames[2].equals(className)) {
                    return Character.valueOf(properties.getChar(propertyName, '\u0000'));
                }
                if (classNames[3].equals(className)) {
                    return properties.getShort(propertyName, (short)0);
                }
                if (classNames[4].equals(className)) {
                    return properties.getInt(propertyName, 0);
                }
                if (classNames[5].equals(className)) {
                    return properties.getLong(propertyName, 0L);
                }
                if (classNames[6].equals(className)) {
                    return Float.valueOf(properties.getFloat(propertyName, 0.0f));
                }
                if (classNames[7].equals(className)) {
                    return properties.getDouble(propertyName, 0.0);
                }
                throw new IllegalArgumentException("Class = '" + className + "'.");
            }

            @Override
            public void write(Object object, Properties properties) {
                if (object instanceof Boolean) {
                    Boolean b = (Boolean)object;
                    properties.setBoolean(propertyName, b);
                } else if (object instanceof Byte) {
                    Byte b = (Byte)object;
                    properties.setByte(propertyName, b);
                } else if (object instanceof Character) {
                    Character c = (Character)object;
                    properties.setChar(propertyName, c.charValue());
                } else if (object instanceof Short) {
                    Short s = (Short)object;
                    properties.setShort(propertyName, s);
                } else if (object instanceof Integer) {
                    Integer i = (Integer)object;
                    properties.setInt(propertyName, i);
                } else if (object instanceof Long) {
                    Long l = (Long)object;
                    properties.setLong(propertyName, l);
                } else if (object instanceof Float) {
                    Float f = (Float)object;
                    properties.setFloat(propertyName, f.floatValue());
                } else if (object instanceof Double) {
                    Double d = (Double)object;
                    properties.setDouble(propertyName, d);
                }
            }
        }
    }

    private static class DelegatingProperties
    extends Properties {
        private PropertiesImpl delegatingProperties;
        private String root;
        private final Map<String, Reference<Properties>> childProperties = new HashMap<String, Reference<Properties>>();
        private final Map<PropertyChangeListener, PropertyChangeListener> delegatingListeners = new WeakHashMap<PropertyChangeListener, PropertyChangeListener>();

        DelegatingProperties(PropertiesImpl properties, String root) {
            this.delegatingProperties = properties;
            this.root = root;
        }

        @Override
        public String getString(String propertyName, String defaultValue) {
            return this.delegatingProperties.getString(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setString(String propertyName, String value) {
            this.delegatingProperties.setString(this.root + "." + propertyName, value);
        }

        @Override
        public int getInt(String propertyName, int defaultValue) {
            return this.delegatingProperties.getInt(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setInt(String propertyName, int value) {
            this.delegatingProperties.setInt(this.root + "." + propertyName, value);
        }

        @Override
        public byte getByte(String propertyName, byte defaultValue) {
            return this.delegatingProperties.getByte(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setByte(String propertyName, byte value) {
            this.delegatingProperties.setByte(this.root + "." + propertyName, value);
        }

        @Override
        public char getChar(String propertyName, char defaultValue) {
            return this.delegatingProperties.getChar(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setChar(String propertyName, char value) {
            this.delegatingProperties.setChar(this.root + "." + propertyName, value);
        }

        @Override
        public boolean getBoolean(String propertyName, boolean defaultValue) {
            return this.delegatingProperties.getBoolean(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setBoolean(String propertyName, boolean value) {
            this.delegatingProperties.setBoolean(this.root + "." + propertyName, value);
        }

        @Override
        public short getShort(String propertyName, short defaultValue) {
            return this.delegatingProperties.getShort(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setShort(String propertyName, short value) {
            this.delegatingProperties.setShort(this.root + "." + propertyName, value);
        }

        @Override
        public long getLong(String propertyName, long defaultValue) {
            return this.delegatingProperties.getLong(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setLong(String propertyName, long value) {
            this.delegatingProperties.setLong(this.root + "." + propertyName, value);
        }

        @Override
        public double getDouble(String propertyName, double defaultValue) {
            return this.delegatingProperties.getDouble(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setDouble(String propertyName, double value) {
            this.delegatingProperties.setDouble(this.root + "." + propertyName, value);
        }

        @Override
        public float getFloat(String propertyName, float defaultValue) {
            return this.delegatingProperties.getFloat(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setFloat(String propertyName, float value) {
            this.delegatingProperties.setFloat(this.root + "." + propertyName, value);
        }

        @Override
        public Object getObject(String propertyName, Object defaultValue) {
            return this.delegatingProperties.getObject(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setObject(String propertyName, Object value) {
            this.delegatingProperties.setObject(this.root + "." + propertyName, value);
        }

        @Override
        public Object[] getArray(String propertyName, Object[] defaultValue) {
            return this.delegatingProperties.getArray(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setArray(String propertyName, Object[] value) {
            this.delegatingProperties.setArray(this.root + "." + propertyName, value);
        }

        @Override
        public Collection getCollection(String propertyName, Collection defaultValue) {
            return this.delegatingProperties.getCollection(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setCollection(String propertyName, Collection value) {
            this.delegatingProperties.setCollection(this.root + "." + propertyName, value);
        }

        @Override
        public Map getMap(String propertyName, Map defaultValue) {
            return this.delegatingProperties.getMap(this.root + "." + propertyName, defaultValue);
        }

        @Override
        public void setMap(String propertyName, Map value) {
            this.delegatingProperties.setMap(this.root + "." + propertyName, value);
        }

        public void unset(String propertyName) {
            this.delegatingProperties.unset(this.root + "." + propertyName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Properties getProperties(String propertyName) {
            Map<String, Reference<Properties>> map = this.childProperties;
            synchronized (map) {
                Properties p;
                Reference<Properties> propRef = this.childProperties.get(propertyName);
                if (propRef != null && (p = propRef.get()) != null) {
                    return p;
                }
                p = new DelegatingProperties(this.delegatingProperties, this.root + "." + propertyName);
                propRef = new WeakReference<Properties>(p);
                this.childProperties.put(propertyName, propRef);
                return p;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
            DelegatingPropertyChangeListener delegate = new DelegatingPropertyChangeListener(l);
            Map<PropertyChangeListener, PropertyChangeListener> map = this.delegatingListeners;
            synchronized (map) {
                this.delegatingListeners.put(l, delegate);
            }
            this.delegatingProperties.addPropertyChangeListener(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
            PropertyChangeListener delegate;
            Map<PropertyChangeListener, PropertyChangeListener> map = this.delegatingListeners;
            synchronized (map) {
                delegate = this.delegatingListeners.get(l);
            }
            if (delegate != null) {
                this.delegatingProperties.removePropertyChangeListener(delegate);
            }
        }

        private class DelegatingPropertyChangeListener
        implements PropertyChangeListener {
            private PropertyChangeListener delegate;
            private String r;
            private int rl;

            public DelegatingPropertyChangeListener(PropertyChangeListener delegate) {
                this.r = DelegatingProperties.this.root + ".";
                this.rl = this.r.length();
                this.delegate = delegate;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (propertyName.length() <= this.rl || !propertyName.startsWith(this.r)) {
                    return;
                }
                PropertyChangeEvent delegateEvt = new PropertyChangeEvent(DelegatingProperties.this, evt.getPropertyName().substring(this.rl), evt.getOldValue(), evt.getNewValue());
                delegateEvt.setPropagationId(evt.getPropagationId());
                this.delegate.propertyChange(delegateEvt);
            }
        }
    }

    private static final class PrimitiveRegister {
        private Map<String, String> properties = new HashMap<String, String>();
        private boolean isInitialized = false;
        private Map<String, ReentrantReadWriteLock> propertyRWLocks = new HashMap<String, ReentrantReadWriteLock>();
        private Map<String, Integer> propertyRWLockCounts = new HashMap<String, Integer>();
        private RequestProcessor.Task task;
        private final boolean[] scheduledLock = new boolean[]{false};

        private PrimitiveRegister() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getProperty(String propertyName, String defaultValue) {
            PrimitiveRegister primitiveRegister = this;
            synchronized (primitiveRegister) {
                String value;
                if (!this.isInitialized) {
                    this.load();
                    this.isInitialized = true;
                }
                if ((value = this.properties.get(propertyName)) != null) {
                    return value;
                }
            }
            return defaultValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProperty(String propertyName, String value) {
            PrimitiveRegister primitiveRegister = this;
            synchronized (primitiveRegister) {
                if (!this.isInitialized) {
                    this.load();
                    this.isInitialized = true;
                }
                this.properties.put(propertyName, value);
            }
            this.save();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeProperty(String propertyName) {
            PrimitiveRegister primitiveRegister = this;
            synchronized (primitiveRegister) {
                if (!this.isInitialized) {
                    this.load();
                    this.isInitialized = true;
                }
                this.properties.remove(propertyName);
            }
            this.save();
        }

        private synchronized ReentrantReadWriteLock getRWLock(String propertyName) {
            Integer c;
            ReentrantReadWriteLock rwl = this.propertyRWLocks.get(propertyName);
            if (rwl == null) {
                rwl = new ReentrantReadWriteLock(true);
                this.propertyRWLocks.put(propertyName, rwl);
            }
            c = (c = this.propertyRWLockCounts.get(propertyName)) == null ? Integer.valueOf(1) : Integer.valueOf(c + 1);
            this.propertyRWLockCounts.put(propertyName, c);
            return rwl;
        }

        public void lockRead(String propertyName) {
            ReentrantReadWriteLock rwl = this.getRWLock(propertyName);
            ReentrantReadWriteLock.ReadLock rl = rwl.readLock();
            rl.lock();
        }

        public void lockWrite(String propertyName) {
            ReentrantReadWriteLock rwl = this.getRWLock(propertyName);
            ReentrantReadWriteLock.WriteLock wl = rwl.writeLock();
            wl.lock();
        }

        public synchronized void unLockRead(String propertyName) {
            ReentrantReadWriteLock rwl = this.propertyRWLocks.get(propertyName);
            if (rwl == null) {
                throw new IllegalStateException("No lock for property " + propertyName);
            }
            rwl.readLock().unlock();
            this.RWUnlock(propertyName);
        }

        public synchronized void unLockWrite(String propertyName) {
            ReentrantReadWriteLock rwl = this.propertyRWLocks.get(propertyName);
            if (rwl == null) {
                throw new IllegalStateException("No lock for property " + propertyName);
            }
            rwl.writeLock().unlock();
            this.RWUnlock(propertyName);
        }

        private synchronized void RWUnlock(String propertyName) {
            Integer c = this.propertyRWLockCounts.get(propertyName);
            if (c == 1) {
                this.propertyRWLockCounts.remove(propertyName);
                this.propertyRWLocks.remove(propertyName);
            } else {
                c = c - 1;
                this.propertyRWLockCounts.put(propertyName, c);
            }
        }

        private synchronized void load() {
            try {
                FileObject fo = PrimitiveRegister.findSettings(false);
                if (fo == null) {
                    return;
                }
                InputStream is = fo.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String l = br.readLine();
                while (l != null) {
                    int i = l.indexOf(58);
                    if (i > 0) {
                        String value = l.substring(i + 1);
                        value = PrimitiveRegister.translateSingleLineStringToMultiLine(value);
                        this.properties.put(l.substring(0, i), value);
                    }
                    l = br.readLine();
                }
                br.close();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, ex.getLocalizedMessage(), ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save() {
            boolean[] blArray = this.scheduledLock;
            synchronized (this.scheduledLock) {
                if (this.task == null) {
                    this.task = new RequestProcessor("Debugger Properties Save RP", 1).create(new Runnable(){

                        @Override
                        public void run() {
                            this.saveIn();
                        }
                    });
                }
                if (!this.scheduledLock[0]) {
                    this.task.schedule(1000);
                    this.scheduledLock[0] = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveIn() {
            boolean[] blArray = this.scheduledLock;
            synchronized (this.scheduledLock) {
                this.scheduledLock[0] = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                PrintWriter pw = null;
                FileLock lock = null;
                try {
                    HashMap<String, String> props;
                    FileObject fo = PrimitiveRegister.findSettings(true);
                    lock = fo.lock();
                    OutputStream os = fo.getOutputStream(lock);
                    pw = new PrintWriter(os);
                    PrimitiveRegister primitiveRegister = this;
                    synchronized (primitiveRegister) {
                        props = new HashMap<String, String>(this.properties);
                    }
                    Set<String> s = props.keySet();
                    ArrayList<String> l = new ArrayList<String>(s);
                    Collections.sort(l);
                    int k = l.size();
                    for (int i = 0; i < k; ++i) {
                        String key = (String)l.get(i);
                        String value = props.get(key);
                        if (value == null) continue;
                        value = PrimitiveRegister.translateMultiLineStringToSingleLine(value.toString());
                        pw.println(key + ":" + String.valueOf(value));
                    }
                    pw.flush();
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, Bundle.MSG_CanNotSaveSettings(), ex);
                }
                finally {
                    try {
                        if (pw != null) {
                            pw.close();
                        }
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
                return;
            }
        }

        private static String translateMultiLineStringToSingleLine(String line) {
            StringBuilder sb = null;
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '\n' || c == 'n' && i > 0 && line.charAt(i - 1) == '\\') {
                    if (sb == null) {
                        sb = new StringBuilder(line.substring(0, i));
                    }
                    sb.append("\\n");
                    continue;
                }
                if (sb == null) continue;
                sb.append(c);
            }
            if (sb == null) {
                return line;
            }
            return sb.toString();
        }

        private static String translateSingleLineStringToMultiLine(String line) {
            StringBuilder sb = null;
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == 'n' && i > 0 && line.charAt(i - 1) == '\\') {
                    if (sb == null) {
                        sb = new StringBuilder(line.substring(0, i - 1));
                    } else {
                        int l = sb.length();
                        sb.delete(l - 1, l);
                    }
                    if (i > 1 && line.charAt(i - 2) == '\\') {
                        sb.append("n");
                        continue;
                    }
                    sb.append("\n");
                    continue;
                }
                if (sb == null) continue;
                sb.append(c);
            }
            if (sb == null) {
                return line;
            }
            return sb.toString();
        }

        private static FileObject findSettings(boolean create) throws IOException {
            FileObject fo;
            FileObject r = FileUtil.getConfigFile((String)"Services");
            if (r == null) {
                if (!create) {
                    return null;
                }
                r = FileUtil.getConfigRoot().createFolder("Services");
            }
            if ((fo = r.getFileObject("org-netbeans-modules-debugger-Settings", "properties")) == null) {
                if (!create) {
                    return null;
                }
                fo = r.createData("org-netbeans-modules-debugger-Settings", "properties");
            }
            return fo;
        }
    }

    public static interface Initializer {
        public String[] getSupportedPropertyNames();

        public Object getDefaultPropertyValue(String var1);
    }

    public static interface Reader {
        public String[] getSupportedClassNames();

        public Object read(String var1, Properties var2);

        public void write(Object var1, Properties var2);
    }
}

