/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.util;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Utils {
    private static Logger LOGGER = Logger.getLogger(Utils.class.getName());

    public static String getHostIpAddress(String hostname) throws UnknownHostException {
        InetAddress inetaddr = InetAddress.getByName(hostname);
        return inetaddr.getHostAddress();
    }

    public static RuntimeException launderThrowable(Throwable t) {
        assert (t != null);
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException("Unexpected exception: " + t.getClass().getName() + ": " + t.getMessage(), t);
    }

    public static void displayError(String msg, Exception ex) {
        LOGGER.log(Level.INFO, msg, ex);
        String reason = ex.getMessage() != null ? ex.getMessage() : Utils.getMessage("MSG_SeeErrorLog", new Object[0]);
        msg = msg + ": " + reason;
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    public static boolean isValidDirectory(String path, boolean emptyOK) {
        return Utils.isValidPath(path, true, emptyOK);
    }

    public static boolean isValidExecutable(String path, boolean emptyOK) {
        return Utils.isValidPath(path, false, emptyOK);
    }

    public static boolean isValidExecutable(String path) {
        return Utils.isValidExecutable(path, false);
    }

    private static boolean isValidPath(String path, boolean isDirectory, boolean emptyOK) {
        if (Utils.isEmpty(path)) {
            return emptyOK;
        }
        File file = new File(path).getAbsoluteFile();
        if (!file.exists()) {
            return false;
        }
        return isDirectory && file.isDirectory() || !isDirectory && file.isFile() || Utilities.isMac() && !isDirectory && path.endsWith(".app");
    }

    public static boolean isValidURL(String url, boolean emptyOK) {
        if (Utils.isEmpty(url)) {
            return emptyOK;
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException ex) {
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String val) {
        return val == null || val.length() == 0;
    }

    public static boolean displayConfirmDialog(String message) {
        NotifyDescriptor.Confirmation ndesc = new NotifyDescriptor.Confirmation((Object)message, 2);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)ndesc);
        return result == NotifyDescriptor.OK_OPTION;
    }

    public static boolean displayYesNoDialog(String message) {
        NotifyDescriptor.Confirmation ndesc = new NotifyDescriptor.Confirmation((Object)message, 0);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)ndesc);
        return result == NotifyDescriptor.YES_OPTION;
    }

    public static void displayErrorMessage(String message) {
        NotifyDescriptor ndesc = new NotifyDescriptor((Object)message, Utils.getBundle().getString("MSG_ErrorDialogTitle"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(ndesc);
    }

    public static boolean stringEquals(String str1, String str2) {
        return str1 == null && str2 == null || str2 != null && str1 != null && str1.equals(str2);
    }

    public static ResourceBundle getBundle() {
        return NbBundle.getBundle(DatabaseServer.class);
    }

    public static String getMessage(String key, Object ... args) {
        return NbBundle.getMessage(DatabaseServer.class, (String)key, (Object[])args);
    }
}

