/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class FinalModifierHintError
extends HintErrorRule {
    private FileObject fileObject;
    private Set<TypeConstantElement> inheritedClassConstants = Collections.emptySet();
    private String classSignatureForInheritedClassConstants = "";

    public String getDisplayName() {
        return Bundle.FinalModifierHintError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkOverridingFinalConstants(fileScope, phpParseResult, hints);
        }
    }

    private void checkOverridingFinalConstants(FileScope fileScope, PHPParseResult phpParseResult, List<Hint> hints) {
        Collection<? extends ClassScope> allClasses = ModelUtils.getDeclaredClasses(fileScope);
        ArrayList<ClassConstantElement> finalConstants = new ArrayList<ClassConstantElement>();
        for (ClassScope classScope : allClasses) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Collection<? extends ClassConstantElement> declaredConstants = classScope.getDeclaredConstants();
            for (ClassConstantElement classConstantElement : declaredConstants) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ElementFilter constantNameFilter = ElementFilter.forName(NameKind.exact(classConstantElement.getName()));
                Set<TypeConstantElement> overridenConstants = constantNameFilter.filter(this.getInheritedClassConstants(phpParseResult, classConstantElement));
                for (TypeConstantElement overridenConstant : overridenConstants) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    if (!overridenConstant.getPhpModifiers().isFinal()) continue;
                    finalConstants.add(classConstantElement);
                }
            }
        }
        for (ClassConstantElement classConstantElement : finalConstants) {
            this.addHint(classConstantElement.getNameRange(), Bundle.FinalModifierHintError_overridingFinalConstant_desc(classConstantElement.getName()), hints, Collections.emptyList());
        }
    }

    private Set<TypeConstantElement> getInheritedClassConstants(ParserResult info, ClassConstantElement constant) {
        Scope inScope = constant.getInScope();
        assert (inScope instanceof TypeScope);
        TypeScope typeScope = (TypeScope)inScope;
        String signature = typeScope.getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedClassConstants)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedClassConstants = index.getInheritedTypeConstants(typeScope);
        }
        this.classSignatureForInheritedClassConstants = signature;
        return Collections.unmodifiableSet(this.inheritedClassConstants);
    }

    private void addHint(OffsetRange offsetRange, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, offsetRange, fixes, 500));
    }
}

