/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.wsdl.websvcmgr;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlDataManager;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WebServiceListManager;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WebServiceManager;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WsdlDataImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WsdlDataManagerImpl
implements WsdlDataManager,
PropertyChangeListener {
    private int precedence = 1;

    @Override
    public WsdlData getWsdlData(String wsdlUrl, String serviceName, boolean synchronuous) {
        return WebServiceListManager.getInstance().findReadyWsdlData(wsdlUrl);
    }

    @Override
    public WsdlData addWsdlData(String wsdlUrl, String packageName) {
        final WsdlDataImpl wsData = new WsdlDataImpl(wsdlUrl);
        wsData.setStatus(WsdlData.Status.WSDL_UNRETRIEVED);
        Runnable addWsRunnable = new Runnable(){
            final /* synthetic */ WsdlDataManagerImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    WebServiceManager.getInstance().addWebService(wsData, true);
                }
                catch (IOException ex) {
                    this.this$0.handleException(ex);
                }
            }
        };
        RequestProcessor.getDefault().post(addWsRunnable);
        return wsData;
    }

    @Override
    public void removeWsdlData(String wsdlUrl, String serviceName) {
        WsdlDataImpl wsData = WebServiceListManager.getInstance().findWsdlData(wsdlUrl);
        if (wsData != null) {
            WebServiceManager.getInstance().removeWebService(wsData);
        }
    }

    @Override
    public void refresh(WsdlData wsdlData) {
        if (wsdlData instanceof WsdlDataImpl) {
            final WsdlDataImpl data = (WsdlDataImpl)wsdlData;
            Runnable addWsRunnable = new Runnable(){
                final /* synthetic */ WsdlDataManagerImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        WebServiceManager.getInstance().refreshWebService(data);
                    }
                    catch (IOException ex) {
                        this.this$0.handleException(ex);
                    }
                }
            };
            RequestProcessor.getDefault().post(addWsRunnable);
        }
    }

    private void handleException(final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ WsdlDataManagerImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (exception instanceof FileNotFoundException) {
                    String errorMessage = NbBundle.getMessage(WsdlDataManagerImpl.class, (String)"INVALID_URL");
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)errorMessage);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                } else {
                    String cause = exception != null ? exception.getLocalizedMessage() : null;
                    String excString = exception != null ? exception.getClass().getName() + " - " + cause : null;
                    String errorMessage = NbBundle.getMessage(WsdlDataManagerImpl.class, (String)"WS_ADD_ERROR", excString);
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)errorMessage);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public WsdlData findWsdlData(String wsdlUrl, String serviceName) {
        return WebServiceListManager.getInstance().findWsdlData(wsdlUrl);
    }

    @Override
    public void setPrecedence(int precedence) {
        this.precedence = precedence;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }
}

