/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.problems.failure;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.internal.exceptions.CompilationFailedIndicator;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.StackFramePredicate;
import org.gradle.internal.problems.failure.StackTraceRelevance;

class DefaultFailure
implements Failure {
    private final Throwable original;
    private final List<StackTraceElement> stackTrace;
    private final List<StackTraceRelevance> frameRelevance;
    private final List<Failure> suppressed;
    private final List<Failure> causes;
    private final List<InternalProblem> problems;

    public DefaultFailure(Throwable original, List<StackTraceElement> stackTrace, List<StackTraceRelevance> frameRelevance, List<Failure> suppressed, List<Failure> causes, List<InternalProblem> problems) {
        if (stackTrace.size() != frameRelevance.size()) {
            throw new IllegalArgumentException("stackTrace and frameRelevance must have the same size.");
        }
        this.original = original;
        this.stackTrace = ImmutableList.copyOf(stackTrace);
        this.frameRelevance = ImmutableList.copyOf(frameRelevance);
        this.suppressed = ImmutableList.copyOf(suppressed);
        this.causes = ImmutableList.copyOf(causes);
        this.problems = ImmutableList.copyOf(problems);
    }

    public Class<? extends Throwable> getExceptionType() {
        return this.original.getClass();
    }

    public String getHeader() {
        return this.original.toString();
    }

    public String getMessage() {
        return this.original instanceof CompilationFailedIndicator ? ((CompilationFailedIndicator)this.original).getShortMessage() : this.original.getMessage();
    }

    public List<StackTraceElement> getStackTrace() {
        return this.stackTrace;
    }

    public StackTraceRelevance getStackTraceRelevance(int frameIndex) {
        return this.frameRelevance.get(frameIndex);
    }

    public List<Failure> getSuppressed() {
        return this.suppressed;
    }

    public List<Failure> getCauses() {
        return this.causes;
    }

    public List<InternalProblem> getProblems() {
        return this.problems;
    }

    public Throwable getOriginal() {
        return this.original;
    }

    public int indexOfStackFrame(int fromIndex, StackFramePredicate predicate) {
        int size = this.stackTrace.size();
        for (int i = fromIndex; i < size; ++i) {
            if (!predicate.test(this.stackTrace.get(i), this.getStackTraceRelevance(i))) continue;
            return i;
        }
        return -1;
    }

    public Failure withoutProblems() {
        return new DefaultFailure(this.original, this.stackTrace, this.frameRelevance, this.suppressed, this.causes, Collections.emptyList());
    }

    public String toString() {
        return "DefaultFailure{original=" + this.original + ", stackTrace=" + this.stackTrace + ", frameRelevance=" + this.frameRelevance + ", suppressed=" + this.suppressed + ", causes=" + this.causes + ", problems=" + this.problems + '}';
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultFailure)) {
            return false;
        }
        DefaultFailure that = (DefaultFailure)o;
        return Objects.equal((Object)this.original, (Object)that.original) && Objects.equal(this.stackTrace, that.stackTrace) && Objects.equal(this.frameRelevance, that.frameRelevance) && Objects.equal(this.suppressed, that.suppressed) && Objects.equal(this.causes, that.causes) && Objects.equal(this.problems, that.problems);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.original, this.stackTrace, this.frameRelevance, this.suppressed, this.causes, this.problems});
    }
}

