﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/fis/FIS_EXPORTS.h>
#include <aws/fis/model/Experiment.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace FIS {
namespace Model {
class StartExperimentResult {
 public:
  AWS_FIS_API StartExperimentResult() = default;
  AWS_FIS_API StartExperimentResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_FIS_API StartExperimentResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Information about the experiment.</p>
   */
  inline const Experiment& GetExperiment() const { return m_experiment; }
  template <typename ExperimentT = Experiment>
  void SetExperiment(ExperimentT&& value) {
    m_experimentHasBeenSet = true;
    m_experiment = std::forward<ExperimentT>(value);
  }
  template <typename ExperimentT = Experiment>
  StartExperimentResult& WithExperiment(ExperimentT&& value) {
    SetExperiment(std::forward<ExperimentT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StartExperimentResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Experiment m_experiment;

  Aws::String m_requestId;
  bool m_experimentHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace FIS
}  // namespace Aws
