/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.AuthnCallback;
import org.apache.subversion.javahl.types.ExternalItem;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.util.ConfigLib;
import org.apache.subversion.javahl.util.DiffLib;
import org.apache.subversion.javahl.util.PropLib;
import org.apache.subversion.javahl.util.SubstLib;

public class SVNUtil {
    private static final ConfigLib configLib = new ConfigLib();
    private static final DiffLib diffLib = new DiffLib();
    private static final PropLib propLib = new PropLib();
    private static final SubstLib substLib = new SubstLib();
    public static final byte[] EOL_LF = SubstLib.EOL_LF;
    public static final byte[] EOL_CR = SubstLib.EOL_CR;
    public static final byte[] EOL_CRLF = SubstLib.EOL_CRLF;

    public static void enableNativeCredentialsStore() throws ClientException {
        configLib.enableNativeCredentialsStore();
    }

    public static void disableNativeCredentialsStore() throws ClientException {
        configLib.disableNativeCredentialsStore();
    }

    public static boolean isNativeCredentialsStoreEnabled() throws ClientException {
        return configLib.isNativeCredentialsStoreEnabled();
    }

    public static Credential getCredential(String string, Credential.Kind kind, String string2) throws ClientException, SubversionException {
        return configLib.getCredential(string, kind, string2);
    }

    public static Credential removeCredential(String string, Credential.Kind kind, String string2) throws ClientException, SubversionException {
        return configLib.removeCredential(string, kind, string2);
    }

    public static List<Credential> searchCredentials(String string, Credential.Kind kind, String string2, String string3, String string4, String string5) throws ClientException, SubversionException {
        return configLib.searchCredentials(string, kind, string2, string3, string4, string5);
    }

    public static boolean fileDiff(String string, String string2, DiffOptions diffOptions, String string3, String string4, String string5, String string6, OutputStream outputStream) throws ClientException {
        return diffLib.fileDiff(string, string2, diffOptions, string3, string4, string5, string6, outputStream);
    }

    public static boolean fileMerge(String string, String string2, String string3, DiffOptions diffOptions, String string4, String string5, String string6, String string7, ConflictDisplayStyle conflictDisplayStyle, OutputStream outputStream) throws ClientException {
        return diffLib.fileMerge(string, string2, string3, diffOptions, string4, string5, string6, string7, conflictDisplayStyle, outputStream);
    }

    public static byte[] canonicalizeNodeProperty(String string, byte[] byArray, String string2, NodeKind nodeKind, String string3) throws ClientException {
        return propLib.canonicalizeNodeProperty(string, byArray, string2, nodeKind, string3, null);
    }

    public static byte[] canonicalizeNodeProperty(String string, byte[] byArray, String string2, NodeKind nodeKind, String string3, InputStream inputStream) throws ClientException {
        return propLib.canonicalizeNodeProperty(string, byArray, string2, nodeKind, string3, inputStream);
    }

    public static List<ExternalItem> parseExternals(byte[] byArray, String string, boolean bl) throws ClientException {
        return propLib.parseExternals(byArray, string, bl);
    }

    public static byte[] unparseExternals(List<ExternalItem> list, String string) throws SubversionException {
        return propLib.unparseExternals(list, string, false);
    }

    public static byte[] unparseExternalsForAncientUnsupportedClients(List<ExternalItem> list, String string) throws SubversionException {
        return propLib.unparseExternals(list, string, true);
    }

    public static String resolveExternalsUrl(ExternalItem externalItem, String string, String string2) throws ClientException {
        return propLib.resolveExternalsUrl(externalItem, string, string2);
    }

    public static Map<String, byte[]> buildKeywords(byte[] byArray, long l, String string, String string2, Date date, String string3) throws SubversionException, ClientException {
        return substLib.buildKeywords(byArray, l, string, string2, date, string3);
    }

    public static InputStream translateStream(InputStream inputStream, byte[] byArray, boolean bl, Map<String, byte[]> map, boolean bl2) throws SubversionException, ClientException {
        return substLib.translateInputStream(inputStream, byArray, bl, map, true, bl2, null, -1L, null, null, null, null);
    }

    public static InputStream translateStream(InputStream inputStream, byte[] byArray, boolean bl, boolean bl2, byte[] byArray2, long l, String string, String string2, Date date, String string3) throws SubversionException, ClientException {
        return substLib.translateInputStream(inputStream, byArray, bl, null, false, bl2, byArray2, l, string, string2, date, string3);
    }

    public static OutputStream translateStream(OutputStream outputStream, byte[] byArray, boolean bl, Map<String, byte[]> map, boolean bl2) throws SubversionException, ClientException {
        return substLib.translateOutputStream(outputStream, byArray, bl, map, true, bl2, null, -1L, null, null, null, null);
    }

    public static OutputStream translateStream(OutputStream outputStream, byte[] byArray, boolean bl, boolean bl2, byte[] byArray2, long l, String string, String string2, Date date, String string3) throws SubversionException, ClientException {
        return substLib.translateOutputStream(outputStream, byArray, bl, null, false, bl2, byArray2, l, string, string2, date, string3);
    }

    public static class Credential
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Kind kind;
        private String realm;
        private String store;
        private String username;
        private String password;
        private AuthnCallback.SSLServerCertInfo info;
        private AuthnCallback.SSLServerCertFailures failures;
        private String passphrase;

        public Kind getKind() {
            return this.kind;
        }

        public String getRealm() {
            return this.realm;
        }

        public String getSecureStore() throws CredentialTypeMismatch {
            if (this.kind != Kind.simple && this.kind != Kind.sslClientPassphrase) {
                throw new CredentialTypeMismatch(this.kind, "secure store");
            }
            return this.store;
        }

        public String getUsername() throws CredentialTypeMismatch {
            if (this.kind != Kind.username && this.kind != Kind.simple) {
                throw new CredentialTypeMismatch(this.kind, "username");
            }
            return this.username;
        }

        public String getPassword() throws CredentialTypeMismatch {
            if (this.kind != Kind.simple && this.kind != Kind.sslClientPassphrase) {
                throw new CredentialTypeMismatch(this.kind, "password");
            }
            return this.password;
        }

        public AuthnCallback.SSLServerCertInfo getServerCertInfo() throws CredentialTypeMismatch {
            if (this.kind != Kind.sslServer) {
                throw new CredentialTypeMismatch(this.kind, "server cert info");
            }
            return this.info;
        }

        public AuthnCallback.SSLServerCertFailures getServerCertFailures() throws CredentialTypeMismatch {
            if (this.kind != Kind.sslServer) {
                throw new CredentialTypeMismatch(this.kind, "server cert failures");
            }
            return this.failures;
        }

        public String getClientCertPassphrase() throws CredentialTypeMismatch {
            if (this.kind != Kind.sslClientPassphrase) {
                throw new CredentialTypeMismatch(this.kind, "passphrase");
            }
            return this.passphrase;
        }

        private Credential(Kind kind, String string, String string2, String string3, String string4, AuthnCallback.SSLServerCertInfo sSLServerCertInfo, AuthnCallback.SSLServerCertFailures sSLServerCertFailures, String string5) {
            assert (kind != null && string != null);
            switch (kind.ordinal()) {
                case 0: {
                    assert (string3 != null && string4 == null && sSLServerCertInfo == null && sSLServerCertFailures == null && string5 == null);
                    break;
                }
                case 1: {
                    assert (string3 != null && string4 != null && sSLServerCertInfo == null && sSLServerCertFailures == null && string5 == null);
                    break;
                }
                case 2: {
                    assert (string3 == null && string4 == null && sSLServerCertInfo != null && sSLServerCertFailures != null && string5 == null);
                    break;
                }
                case 3: {
                    assert (string3 == null && string4 == null && sSLServerCertInfo == null && sSLServerCertFailures == null && string5 != null);
                    break;
                }
                default: {
                    assert (kind == Kind.username || kind == Kind.simple || kind == Kind.sslServer || kind == Kind.sslClientPassphrase);
                    break;
                }
            }
            this.kind = kind;
            this.realm = string;
            this.store = string2;
            this.username = string3;
            this.password = string4;
            this.info = sSLServerCertInfo;
            this.failures = sSLServerCertFailures;
            this.passphrase = string5;
        }

        public static enum Kind {
            username("svn.username"),
            simple("svn.simple"),
            sslServer("svn.ssl.server"),
            sslClientPassphrase("svn.ssl.client-passphrase");

            private String token;

            private Kind(String string2) {
                this.token = string2;
            }

            public String toString() {
                return this.token;
            }

            private static Kind fromString(String string) {
                for (Kind kind : Kind.values()) {
                    if (!kind.toString().equals(string)) continue;
                    return kind;
                }
                return null;
            }
        }
    }

    public static class DiffOptions {
        public final IgnoreSpace ignoreSpace;
        public final boolean ignoreEolStyle;
        public final boolean showCFunction;
        public final int contextSize;

        public DiffOptions(IgnoreSpace ignoreSpace, boolean bl, boolean bl2) {
            this.ignoreSpace = ignoreSpace;
            this.ignoreEolStyle = bl;
            this.showCFunction = bl2;
            this.contextSize = -1;
        }

        public DiffOptions(IgnoreSpace ignoreSpace, boolean bl, boolean bl2, int n) {
            this.ignoreSpace = ignoreSpace;
            this.ignoreEolStyle = bl;
            this.showCFunction = bl2;
            this.contextSize = n;
        }

        public static enum IgnoreSpace {
            none,
            change,
            all;

        }
    }

    public static enum ConflictDisplayStyle {
        modified_latest,
        resolved_modified_latest,
        modified_original_latest,
        modified,
        latest,
        only_conflicts;

    }

    public static class CredentialTypeMismatch
    extends SubversionException {
        private static final long serialVersionUID = 1L;

        public CredentialTypeMismatch(Credential.Kind kind, String string) {
            super("Credential type '" + kind.toString() + "'  does not have the attribute '" + string + "'");
        }
    }
}

