/*
 * Decompiled with CFR 0.152.
 */
package hughai.utils;

import hughai.PlayerObjects;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeHelper {
    PlayerObjects playerObjects;

    public TimeHelper(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
    }

    public RealTimePoint GetRealTimePoint() {
        return new RealTimePoint(System.currentTimeMillis());
    }

    public GameTimePoint GetGameTimePoint() {
        return new GameTimePoint(this.getCurrentFrame());
    }

    public int getCurrentFrame() {
        return this.playerObjects.getFrameController().getFrame();
    }

    public double getGameTimeSeconds() {
        int n = this.playerObjects.getFrameController().getFrame();
        return (double)n / 30.0;
    }

    public String GetCurrentGameTimeString() {
        double d = this.getGameTimeSeconds();
        TimeSpan timeSpan = new TimeSpan(d);
        return "" + timeSpan;
    }

    public String GetCurrentRealTimeString() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public String FormatTimeSpan(TimeSpan timeSpan) {
        return "" + timeSpan;
    }

    public TimeSpan CompareRealTimePoint(RealTimePoint realTimePoint, RealTimePoint realTimePoint2) {
        return new TimeSpan(realTimePoint.milliseconds - realTimePoint2.milliseconds);
    }

    public static class TimeSpan {
        public int hours;
        public int minutes;
        public int seconds;
        public int milliseconds;

        public TimeSpan() {
        }

        public TimeSpan(int n, int n2, int n3, int n4) {
            this.hours = n;
            this.minutes = n2;
            this.seconds = n3;
            this.milliseconds = n4;
        }

        public void add(TimeSpan timeSpan) {
            this.fromMilliseconds(this.getTotalMilliseconds() + timeSpan.getTotalMilliseconds());
        }

        public TimeSpan(double d) {
            this.fromMilliseconds((long)(d * 1000.0));
        }

        public TimeSpan(long l) {
            this.fromMilliseconds(l);
        }

        public long getTotalMilliseconds() {
            return (long)this.hours * 1000L * 60L * 60L + (long)this.minutes * 1000L * 60L + (long)this.seconds * 1000L + (long)this.milliseconds;
        }

        void fromMilliseconds(long l) {
            this.hours = (int)(l / 60L / 60L / 1000L);
            this.minutes = (int)((l -= (long)(this.hours * 60 * 60 * 1000)) / 60L / 1000L);
            this.seconds = (int)((l -= (long)(this.minutes * 60 * 1000)) / 1000L);
            this.milliseconds = (int)(l -= (long)(this.seconds * 1000));
        }

        public String toString() {
            if (this.getTotalMilliseconds() < 1000L) {
                return this.milliseconds + " ms";
            }
            return this.hours + ":" + this.minutes + ":" + this.seconds + "." + this.milliseconds;
        }
    }

    public static class RealTimePoint
    extends TimePoint {
        public long milliseconds;

        public RealTimePoint() {
        }

        public RealTimePoint(double d) {
            this.milliseconds = (long)(d * 1000.0);
        }

        public RealTimePoint(long l) {
            this.milliseconds = l;
        }
    }

    public static class GameTimePoint
    extends TimePoint {
        public int frame;

        public GameTimePoint() {
        }

        public GameTimePoint(int n) {
            this.frame = n;
        }

        public TimeSpan asTimeSpan() {
            return new TimeSpan(this.frame * 1000 / 30);
        }

        public String toString() {
            return "" + this.asTimeSpan();
        }
    }

    public static class TimePoint {
    }
}

