/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.apache.solr.client.api.model.CreateCoreSnapshotResponse;
import org.apache.solr.client.api.model.DeleteSnapshotResponse;
import org.apache.solr.client.api.model.ListCoreSnapshotsResponse;

@Path(value="/cores/{coreName}/snapshots")
public interface CoreSnapshotApi {
    @POST
    @Path(value="/{snapshotName}")
    @Operation(summary="Create a new snapshot of the specified core.", tags={"core-snapshots"})
    public CreateCoreSnapshotResponse createSnapshot(@Parameter(description="The name of the core to snapshot.", required=true) @PathParam(value="coreName") String var1, @Parameter(description="The name to associate with the core snapshot.", required=true) @PathParam(value="snapshotName") String var2, @Parameter(description="The id to associate with the async task.") @QueryParam(value="async") String var3) throws Exception;

    @GET
    @Operation(summary="List existing snapshots for the specified core.", tags={"core-snapshots"})
    public ListCoreSnapshotsResponse listSnapshots(@Parameter(description="The name of the core for which to retrieve snapshots.", required=true) @PathParam(value="coreName") String var1) throws Exception;

    @DELETE
    @Path(value="/{snapshotName}")
    @Operation(summary="Delete a single snapshot from the specified core.", tags={"core-snapshots"})
    public DeleteSnapshotResponse deleteSnapshot(@Parameter(description="The name of the core for which to delete a snapshot.", required=true) @PathParam(value="coreName") String var1, @Parameter(description="The name of the core snapshot to delete.", required=true) @PathParam(value="snapshotName") String var2, @Parameter(description="The id to associate with the async task.") @QueryParam(value="async") String var3) throws Exception;
}

