/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai.internal.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.mistralai.internal.api.MistralAiApi;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionChoice;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiEmbeddingRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiEmbeddingResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiModelResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiToolCall;
import dev.langchain4j.model.mistralai.internal.api.MistralAiUsage;
import dev.langchain4j.model.mistralai.internal.client.MistralAiApiKeyInterceptor;
import dev.langchain4j.model.mistralai.internal.client.MistralAiClient;
import dev.langchain4j.model.mistralai.internal.client.MistralAiRequestLoggingInterceptor;
import dev.langchain4j.model.mistralai.internal.client.MistralAiResponseLoggingInterceptor;
import dev.langchain4j.model.mistralai.internal.mapper.MistralAiMapper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.io.IOException;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class DefaultMistralAiClient
extends MistralAiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMistralAiClient.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final MistralAiApi mistralAiApi;
    private final OkHttpClient okHttpClient;
    private final boolean logStreamingResponses;

    public static Builder builder() {
        return new Builder();
    }

    DefaultMistralAiClient(Builder builder) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(builder.timeout).connectTimeout(builder.timeout).readTimeout(builder.timeout).writeTimeout(builder.timeout);
        okHttpClientBuilder.addInterceptor((Interceptor)new MistralAiApiKeyInterceptor(builder.apiKey));
        if (builder.logRequests.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new MistralAiRequestLoggingInterceptor());
        }
        if (builder.logResponses.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new MistralAiResponseLoggingInterceptor());
        }
        this.logStreamingResponses = builder.logResponses;
        this.okHttpClient = okHttpClientBuilder.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)builder.baseUrl)).client(this.okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)OBJECT_MAPPER)).build();
        this.mistralAiApi = (MistralAiApi)retrofit.create(MistralAiApi.class);
    }

    @Override
    public MistralAiChatCompletionResponse chatCompletion(MistralAiChatCompletionRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.mistralAiApi.chatCompletion(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (MistralAiChatCompletionResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void streamingChatCompletion(MistralAiChatCompletionRequest request, final StreamingResponseHandler<AiMessage> handler) {
        EventSourceListener eventSourceListener = new EventSourceListener(){
            final StringBuffer contentBuilder = new StringBuffer();
            List<ToolExecutionRequest> toolExecutionRequests;
            TokenUsage tokenUsage;
            FinishReason finishReason;

            public void onOpen(EventSource eventSource, okhttp3.Response response) {
                if (DefaultMistralAiClient.this.logStreamingResponses) {
                    LOGGER.debug("onOpen()");
                }
            }

            public void onEvent(EventSource eventSource, String id, String type, String data) {
                if (DefaultMistralAiClient.this.logStreamingResponses) {
                    LOGGER.debug("onEvent() {}", (Object)data);
                }
                if ("[DONE]".equals(data)) {
                    AiMessage aiMessage = !Utils.isNullOrEmpty(this.toolExecutionRequests) ? AiMessage.from(this.toolExecutionRequests) : AiMessage.from((String)this.contentBuilder.toString());
                    Response response = Response.from((Object)aiMessage, (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
                    handler.onComplete(response);
                } else {
                    try {
                        String finishReasonString;
                        MistralAiUsage usageInfo;
                        List<MistralAiToolCall> toolCalls;
                        MistralAiChatCompletionResponse chatCompletionResponse = (MistralAiChatCompletionResponse)OBJECT_MAPPER.readValue(data, MistralAiChatCompletionResponse.class);
                        MistralAiChatCompletionChoice choice = chatCompletionResponse.getChoices().get(0);
                        String chunk = choice.getDelta().getContent();
                        if (Utils.isNotNullOrEmpty((String)chunk)) {
                            this.contentBuilder.append(chunk);
                            handler.onNext(chunk);
                        }
                        if (!Utils.isNullOrEmpty(toolCalls = choice.getDelta().getToolCalls())) {
                            this.toolExecutionRequests = MistralAiMapper.toToolExecutionRequests(toolCalls);
                        }
                        if ((usageInfo = chatCompletionResponse.getUsage()) != null) {
                            this.tokenUsage = MistralAiMapper.tokenUsageFrom(usageInfo);
                        }
                        if ((finishReasonString = choice.getFinishReason()) != null) {
                            this.finishReason = MistralAiMapper.finishReasonFrom(finishReasonString);
                        }
                    }
                    catch (Exception e) {
                        handler.onError((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }

            public void onFailure(EventSource eventSource, Throwable t, okhttp3.Response response) {
                if (DefaultMistralAiClient.this.logStreamingResponses) {
                    LOGGER.debug("onFailure()", t);
                }
                if (t != null) {
                    handler.onError(t);
                } else {
                    handler.onError((Throwable)new RuntimeException(String.format("status code: %s; body: %s", response.code(), response.body())));
                }
            }

            public void onClosed(EventSource eventSource) {
                if (DefaultMistralAiClient.this.logStreamingResponses) {
                    LOGGER.debug("onClosed()");
                }
            }
        };
        EventSources.createFactory((OkHttpClient)this.okHttpClient).newEventSource(this.mistralAiApi.streamingChatCompletion(request).request(), eventSourceListener);
    }

    @Override
    public MistralAiEmbeddingResponse embedding(MistralAiEmbeddingRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.mistralAiApi.embedding(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (MistralAiEmbeddingResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MistralAiModelResponse listModels() {
        try {
            retrofit2.Response retrofitResponse = this.mistralAiApi.models().execute();
            if (retrofitResponse.isSuccessful()) {
                return (MistralAiModelResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RuntimeException toException(retrofit2.Response<?> retrofitResponse) throws IOException {
        ResponseBody errorBody;
        int code = retrofitResponse.code();
        if (code >= 400 && (errorBody = retrofitResponse.errorBody()) != null) {
            String errorBodyString = errorBody.string();
            String errorMessage = String.format("status code: %s; body: %s", code, errorBodyString);
            LOGGER.error("Error response: {}", (Object)errorMessage);
            return new RuntimeException(errorMessage);
        }
        return new RuntimeException(retrofitResponse.message());
    }

    public static class Builder
    extends MistralAiClient.Builder<DefaultMistralAiClient, Builder> {
        @Override
        public DefaultMistralAiClient build() {
            return new DefaultMistralAiClient(this);
        }
    }
}

