/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.entries;

import com.j256.simplemagic.entries.IanaEntry;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class IanaEntries {
    private static final String INTERNAL_IANA_APP_DB = "/iana_app.gz";
    private static final String INTERNAL_IANA_AUDIO_DB = "/iana_audio.gz";
    private static final String INTERNAL_IANA_FONT_DB = "/iana_font.gz";
    private final Map<String, IanaEntry> entryMap = new HashMap<String, IanaEntry>();
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\[(.+?)\\]");

    public IanaEntries() {
        this.loadFile(INTERNAL_IANA_APP_DB);
        this.loadFile(INTERNAL_IANA_AUDIO_DB);
        this.loadFile(INTERNAL_IANA_FONT_DB);
    }

    public IanaEntry lookupByMimeType(String mimeType) {
        return this.entryMap.get(mimeType);
    }

    private void loadFile(String resourcePath) {
        InputStream stream = this.getClass().getResourceAsStream(resourcePath);
        if (stream == null) {
            throw new IllegalArgumentException(resourcePath + " is missing");
        }
        BufferedReader lineReader = null;
        try {
            String line;
            lineReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(stream)));
            stream = null;
            lineReader.readLine();
            while ((line = lineReader.readLine()) != null) {
                String[] parsed = line.split(",");
                if (parsed.length < 3) continue;
                String name = parsed[0];
                String mimeType = parsed[1];
                if (mimeType.isEmpty()) continue;
                String reference = parsed[2];
                if (reference.startsWith("\"")) {
                    String nextLine = lineReader.readLine();
                    nextLine = nextLine.replaceAll("\\s+", "");
                    reference = reference + nextLine;
                }
                IanaEntry ianaEntry = new IanaEntry(name, mimeType, this.parseReference(reference));
                this.entryMap.put(mimeType, ianaEntry);
            }
            this.closeQuietly(lineReader);
            this.closeQuietly(stream);
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException("Error when loading " + resourcePath, ioe);
            }
            catch (Throwable throwable) {
                this.closeQuietly(lineReader);
                this.closeQuietly(stream);
                throw throwable;
            }
        }
    }

    private List<String> parseReference(String reference) {
        ArrayList<String> references = new ArrayList<String>();
        Matcher matcher = REFERENCE_PATTERN.matcher(reference);
        while (matcher.find()) {
            references.add(matcher.group(1));
        }
        return references;
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

