/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.ReplicaMigrationUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.NamedList;

public class ReplaceNodeCmd
implements CollApiCmds.CollectionApiCommand {
    private final CollectionCommandContext ccc;

    public ReplaceNodeCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        boolean migrationSuccessful;
        ZkStateReader zkStateReader = this.ccc.getZkStateReader();
        String source = message.getStr("sourceNode");
        String target = message.getStr("targetNode");
        boolean waitForFinalState = message.getBool("waitForFinalState", false);
        if (source == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "sourceNode is a required param");
        }
        String async = message.getStr("async");
        int timeout = message.getInt("timeout", Integer.valueOf(600));
        boolean parallel = message.getBool("parallel", false);
        ClusterState clusterState = zkStateReader.getClusterState();
        if (target != null && !clusterState.liveNodesContain(target)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target node: " + target + " is not live");
        }
        if (clusterState.getLiveNodes().size() <= 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No nodes other than the source node: " + source + " are live, therefore replicas cannot be moved");
        }
        if (source.equals(target)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target node: " + target + " cannot be the same as source node");
        }
        List<Replica> sourceReplicas = ReplicaMigrationUtils.getReplicasOfNode(source, clusterState);
        HashMap replicaMovements = CollectionUtil.newHashMap((int)sourceReplicas.size());
        if (target == null || target.isEmpty()) {
            ArrayList assignRequests = new ArrayList(sourceReplicas.size());
            for (Replica sourceReplica : sourceReplicas) {
                Replica.Type replicaType = sourceReplica.getType();
                int numNrtReplicas = replicaType == Replica.Type.NRT ? 1 : 0;
                int numTlogReplicas = replicaType == Replica.Type.TLOG ? 1 : 0;
                int numPullReplicas = replicaType == Replica.Type.PULL ? 1 : 0;
                Assign.AssignRequest assignRequest = new Assign.AssignRequestBuilder().forCollection(sourceReplica.getCollection()).forShard(Collections.singletonList(sourceReplica.getShard())).assignNrtReplicas(numNrtReplicas).assignTlogReplicas(numTlogReplicas).assignPullReplicas(numPullReplicas).onNodes(this.ccc.getSolrCloudManager().getClusterStateProvider().getLiveNodes().stream().filter(node -> !node.equals(source)).collect(Collectors.toList())).build();
                assignRequests.add(assignRequest);
            }
            Assign.AssignStrategy assignStrategy = Assign.createAssignStrategy(this.ccc.getCoreContainer());
            List<ReplicaPosition> replicaPositions = assignStrategy.assign(this.ccc.getSolrCloudManager(), assignRequests);
            int position = 0;
            for (Replica sourceReplica : sourceReplicas) {
                replicaMovements.put(sourceReplica, replicaPositions.get((int)position++).node);
            }
        } else {
            for (Replica sourceReplica : sourceReplicas) {
                replicaMovements.put(sourceReplica, target);
            }
        }
        if (migrationSuccessful = ReplicaMigrationUtils.migrateReplicas(this.ccc, replicaMovements, parallel, waitForFinalState, timeout, async, results)) {
            results.add("success", (Object)("REPLACENODE action completed successfully from  : " + source + " to : " + target));
        }
    }
}

