/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ForwardOnlyStorageException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class ChannelFactory {
    private static final Set<StandardOpenOption> ILLEGAL_OPTIONS = EnumSet.of(StandardOpenOption.APPEND, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE);
    public final boolean suggestDirectBuffer;

    protected ChannelFactory(boolean bl) {
        this.suggestDirectBuffer = bl;
    }

    public static ChannelFactory prepare(Object object, boolean bl, String string, OpenOption[] openOptionArray, UnaryOperator<ChannelFactory> unaryOperator) throws IOException {
        ChannelFactory channelFactory = ChannelFactory.prepare(object, bl, string, openOptionArray);
        if (channelFactory != null && unaryOperator != null) {
            channelFactory = (ChannelFactory)unaryOperator.apply(channelFactory);
        }
        return channelFactory;
    }

    private static ChannelFactory prepare(Object object, boolean bl, String string, OpenOption[] openOptionArray) throws IOException {
        Object object2;
        Set<StandardOpenOption> set;
        block23: {
            if (openOptionArray == null || openOptionArray.length == 0) {
                set = Collections.singleton(StandardOpenOption.READ);
            } else {
                set = new HashSet<OpenOption>(Arrays.asList(openOptionArray));
                set.add(StandardOpenOption.READ);
                if (!bl && set.removeAll(ILLEGAL_OPTIONS)) {
                    throw new IllegalArgumentException(Errors.format((short)45, "options", Arrays.toString(openOptionArray)));
                }
            }
            if (object instanceof ReadableByteChannel || bl && object instanceof WritableByteChannel) {
                return new Stream(object, object instanceof FileChannel);
            }
            if (object instanceof InputStream) {
                return new Stream(object, object.getClass() == FileInputStream.class);
            }
            if (bl && object instanceof OutputStream) {
                return new Stream(object, object.getClass() == FileOutputStream.class);
            }
            if (object instanceof URL) {
                try {
                    object = IOUtilities.toPath((URL)object, string);
                }
                catch (IOException iOException) {
                    ChannelFactory.recoverableException(iOException);
                }
            } else if (object instanceof URI) {
                object2 = (URI)object;
                if (!((URI)object2).isAbsolute()) {
                    throw new IOException(Resources.format((short)11, object2));
                }
                try {
                    object = Paths.get((URI)object2);
                }
                catch (IllegalArgumentException | FileSystemNotFoundException runtimeException) {
                    try {
                        object = ((URI)object2).toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.addSuppressed(runtimeException);
                        throw malformedURLException;
                    }
                    ChannelFactory.recoverableException(runtimeException);
                }
            } else {
                if (object instanceof CharSequence) {
                    object = IOUtilities.toFileOrURL(object.toString(), string);
                }
                if (object instanceof File) {
                    object2 = (File)object;
                    try {
                        object = ((File)object2).toPath();
                    }
                    catch (InvalidPathException invalidPathException) {
                        if (!((File)object2).isFile()) break block23;
                        return new Fallback((File)object2, invalidPathException);
                    }
                }
            }
        }
        if (object instanceof URL) {
            object2 = (URL)object;
            return new ChannelFactory(false, (URL)object2){
                final /* synthetic */ URL val$file;
                {
                    this.val$file = uRL;
                    super(bl);
                }

                @Override
                public InputStream inputStream(String string, StoreListeners storeListeners) throws IOException {
                    return this.val$file.openStream();
                }

                @Override
                public OutputStream outputStream(String string, StoreListeners storeListeners) throws IOException {
                    return this.val$file.openConnection().getOutputStream();
                }

                @Override
                public ReadableByteChannel readable(String string, StoreListeners storeListeners) throws IOException {
                    return Channels.newChannel(this.val$file.openStream());
                }

                @Override
                public WritableByteChannel writable(String string, StoreListeners storeListeners) throws IOException {
                    return Channels.newChannel(this.val$file.openConnection().getOutputStream());
                }
            };
        }
        if (object instanceof Path && !Files.isDirectory((Path)(object2 = (Path)object), new LinkOption[0])) {
            return new ChannelFactory(true, (Path)object2, set){
                final /* synthetic */ Path val$path;
                final /* synthetic */ Set val$optionSet;
                {
                    this.val$path = path;
                    this.val$optionSet = set;
                    super(bl);
                }

                @Override
                public ReadableByteChannel readable(String string, StoreListeners storeListeners) throws IOException {
                    return Files.newByteChannel(this.val$path, this.val$optionSet, new FileAttribute[0]);
                }

                @Override
                public WritableByteChannel writable(String string, StoreListeners storeListeners) throws IOException {
                    return Files.newByteChannel(this.val$path, this.val$optionSet, new FileAttribute[0]);
                }
            };
        }
        return null;
    }

    public boolean isCoupled() {
        return false;
    }

    public boolean canOpen() {
        return true;
    }

    public InputStream inputStream(String string, StoreListeners storeListeners) throws DataStoreException, IOException {
        return Channels.newInputStream(this.readable(string, storeListeners));
    }

    public OutputStream outputStream(String string, StoreListeners storeListeners) throws DataStoreException, IOException {
        return Channels.newOutputStream(this.writable(string, storeListeners));
    }

    public abstract ReadableByteChannel readable(String var1, StoreListeners var2) throws DataStoreException, IOException;

    public abstract WritableByteChannel writable(String var1, StoreListeners var2) throws DataStoreException, IOException;

    private static void recoverableException(Exception exception) {
        Logging.recoverableException(StoreUtilities.LOGGER, ChannelFactory.class, "prepare", exception);
    }

    private static final class Stream
    extends ChannelFactory {
        private Object storage;

        Stream(Object object, boolean bl) {
            super(bl);
            this.storage = object;
        }

        @Override
        public boolean isCoupled() {
            return true;
        }

        @Override
        public boolean canOpen() {
            return this.storage != null;
        }

        @Override
        public InputStream inputStream(String string, StoreListeners storeListeners) throws DataStoreException, IOException {
            Object object = this.storage;
            if (object instanceof InputStream) {
                this.storage = null;
                return (InputStream)object;
            }
            return super.inputStream(string, storeListeners);
        }

        @Override
        public OutputStream outputStream(String string, StoreListeners storeListeners) throws DataStoreException, IOException {
            Object object = this.storage;
            if (object instanceof OutputStream) {
                this.storage = null;
                return (OutputStream)object;
            }
            return super.outputStream(string, storeListeners);
        }

        @Override
        public ReadableByteChannel readable(String string, StoreListeners storeListeners) throws DataStoreException, IOException {
            Object object = this.storage;
            if (object instanceof ReadableByteChannel) {
                this.storage = null;
                return (ReadableByteChannel)object;
            }
            if (object instanceof InputStream) {
                this.storage = null;
                return Channels.newChannel((InputStream)object);
            }
            String string2 = Resources.format(object != null ? (short)25 : 18, string);
            if (object != null) {
                throw new IOException(string2);
            }
            throw new ForwardOnlyStorageException(string2);
        }

        @Override
        public WritableByteChannel writable(String string, StoreListeners storeListeners) throws DataStoreException, IOException {
            Object object = this.storage;
            if (object instanceof WritableByteChannel) {
                this.storage = null;
                return (WritableByteChannel)object;
            }
            if (object instanceof OutputStream) {
                this.storage = null;
                return Channels.newChannel((OutputStream)object);
            }
            String string2 = Resources.format(object != null ? (short)26 : 21, string);
            if (object != null) {
                throw new IOException(string2);
            }
            throw new ForwardOnlyStorageException(string2);
        }
    }

    private static final class Fallback
    extends ChannelFactory {
        private final File file;
        private InvalidPathException cause;

        Fallback(File file, InvalidPathException invalidPathException) {
            super(true);
            this.file = file;
            this.cause = invalidPathException;
        }

        @Override
        public FileInputStream inputStream(String string, StoreListeners storeListeners) throws IOException {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(this.file);
            }
            catch (IOException iOException) {
                if (this.cause != null) {
                    iOException.addSuppressed(this.cause);
                    this.cause = null;
                }
                throw iOException;
            }
            this.warning("inputStream", storeListeners);
            return fileInputStream;
        }

        @Override
        public FileOutputStream outputStream(String string, StoreListeners storeListeners) throws IOException {
            FileOutputStream fileOutputStream;
            try {
                fileOutputStream = new FileOutputStream(this.file);
            }
            catch (IOException iOException) {
                if (this.cause != null) {
                    iOException.addSuppressed(this.cause);
                    this.cause = null;
                }
                throw iOException;
            }
            this.warning("outputStream", storeListeners);
            return fileOutputStream;
        }

        private void warning(String string, StoreListeners storeListeners) {
            if (this.cause != null) {
                LogRecord logRecord = new LogRecord(Level.WARNING, this.cause.toString());
                logRecord.setLoggerName("org.apache.sis.storage");
                logRecord.setSourceMethodName(string);
                logRecord.setSourceClassName(ChannelFactory.class.getName());
                logRecord.setThrown(this.cause);
                this.cause = null;
                if (storeListeners != null) {
                    storeListeners.warning(logRecord);
                } else {
                    StoreUtilities.LOGGER.log(logRecord);
                }
            }
        }

        @Override
        public ReadableByteChannel readable(String string, StoreListeners storeListeners) throws IOException {
            return this.inputStream(string, storeListeners).getChannel();
        }

        @Override
        public WritableByteChannel writable(String string, StoreListeners storeListeners) throws IOException {
            return this.outputStream(string, storeListeners).getChannel();
        }
    }
}

