/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.ExtensibleDrawable;
import net.sf.sdedit.drawable.Line;
import net.sf.sdedit.util.Direction;

public abstract class SequenceElement
extends Drawable
implements Constants {
    private ExtensibleDrawable leftEndpoint;
    private ExtensibleDrawable leftLimit;
    private ExtensibleDrawable rightEndpoint;
    private ExtensibleDrawable rightLimit;
    private Direction align;
    private int rightPadding;
    private int leftPadding;
    protected final Configuration configuration;

    protected SequenceElement(SequenceDiagram diagram, Lifeline boundary0, Lifeline boundary1, String[] text, Direction align, int y) {
        super(diagram);
        this.setTop(y);
        this.addLabel().setLabel(text);
        this.align = align;
        this.configuration = this.configuration();
        this.findEndpoints(boundary0, boundary1);
        this.computePadding();
    }

    protected final SequenceDiagram diagram() {
        return (SequenceDiagram)this.getDiagram();
    }

    protected final int rightPadding() {
        return this.rightPadding;
    }

    protected final int leftPadding() {
        return this.leftPadding;
    }

    protected final SequenceConfiguration configuration() {
        return this.diagram().getConfiguration();
    }

    public final Direction getAlign() {
        return this.align;
    }

    private void computePadding() {
        Lifeline leftMost;
        Lifeline right;
        Lifeline rightMost;
        Lifeline left;
        int main = this.diagram().mainLifelineWidth;
        int sub = this.diagram().subLifelineWidth;
        this.leftPadding = this.leftEndpoint != null ? ((left = this.leftEndpoint.getLifeline()) != null ? (left == (rightMost = left.getRightmost()) ? 0 : (rightMost.getDirection() == Direction.CENTER ? main + (left.getSideLevel() - 1) * sub : (left.getDirection() == Direction.LEFT ? main + (left.getSideLevel() - 1) * sub + rightMost.getSideLevel() * sub : (rightMost.getSideLevel() - left.getSideLevel()) * sub))) : 0) : 0;
        this.rightPadding = this.rightEndpoint != null ? ((right = this.rightEndpoint.getLifeline()) != null ? (right == (leftMost = right.getLeftmost()) ? 0 : (leftMost.getDirection() == Direction.CENTER ? main + (right.getSideLevel() - 1) * sub : (right.getDirection() == Direction.RIGHT ? main + (right.getSideLevel() - 1) * sub + leftMost.getSideLevel() * sub : (leftMost.getSideLevel() - right.getSideLevel()) * sub))) : 0) : 0;
    }

    public int getSpace() {
        return 0;
    }

    public ExtensibleDrawable getLeftEndpoint() {
        return this.leftEndpoint;
    }

    public ExtensibleDrawable getRightEndpoint() {
        return this.rightEndpoint;
    }

    protected void setLeftEndpoint(ExtensibleDrawable leftEndpoint) {
        this.leftEndpoint = leftEndpoint;
    }

    protected void setRightEndpoint(ExtensibleDrawable rightEndpoint) {
        this.rightEndpoint = rightEndpoint;
    }

    private void findEndpoints(Lifeline boundary0, Lifeline boundary1) {
        if (boundary1 == null) {
            if (boundary0.getDirection() == Direction.LEFT) {
                this.leftEndpoint = boundary0.getLeftNeighbour().getView();
                this.rightEndpoint = boundary0.getView();
            } else {
                this.leftEndpoint = boundary0.getView();
                this.rightEndpoint = boundary0.getPosition() < this.diagram().getNumberOfLifelines() - 1 ? boundary0.getRightNeighbour().getView() : (Line)this.diagram().getPaintDevice().callSpecial("getRightBound", null);
            }
        } else if (boundary0.getPosition() < boundary1.getPosition()) {
            this.leftEndpoint = boundary0.getView();
            this.rightEndpoint = boundary1.getView();
        } else {
            this.leftEndpoint = boundary1.getView();
            this.rightEndpoint = boundary0.getView();
        }
    }

    public final ExtensibleDrawable getLeftLimit() {
        return this.leftLimit;
    }

    public final void setLeftLimit(ExtensibleDrawable leftLimit) {
        this.leftLimit = leftLimit;
    }

    public final ExtensibleDrawable getRightLimit() {
        return this.rightLimit;
    }

    public final void setRightLimit(ExtensibleDrawable rightLimit) {
        this.rightLimit = rightLimit;
    }
}

