/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.replay.driver.TxnReplayableStruct;
import oracle.sql.ANYDATA;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;
import oracle.sql.json.OracleJsonDatum;
import oracle.xdb.XMLType;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class AQMessageI
implements AQMessage {
    private byte[] id;
    private AQMessagePropertiesI properties;
    private byte[] toid;
    private int version;
    private byte[] payload;
    private OracleStruct payLoadStruct;
    private ANYDATA payLoadANYDATA;
    private RAW payLoadRAW;
    private XMLType payLoadXMLType;
    private OracleJsonDatum payloadJson;
    private Connection conn;
    private String typeName;
    private TypeDescriptor sd;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    AQMessageI(AQMessagePropertiesI _prop, Connection _conn) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, AQMessageI.class, $$$methodRef$$$30, null, _prop, _conn);
            }
            this.id = null;
            this.properties = null;
            this.toid = null;
            this.version = 1;
            this.properties = _prop;
            this.conn = _conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, AQMessageI.class, $$$methodRef$$$30, null);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, AQMessageI.class, $$$methodRef$$$30, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, AQMessageI.class, $$$methodRef$$$30, null, throwable2);
            }
            throw throwable;
        }
    }

    AQMessageI(AQMessagePropertiesI prop) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, AQMessageI.class, $$$methodRef$$$31, null, prop);
            }
            this.id = null;
            this.properties = null;
            this.toid = null;
            this.version = 1;
            this.properties = prop;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, AQMessageI.class, $$$methodRef$$$31, null);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, AQMessageI.class, $$$methodRef$$$31, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, AQMessageI.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setTypeName(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _typeName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, AQMessageI.class, $$$methodRef$$$0, this, string);
            }
            this.typeName = _typeName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, AQMessageI.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, AQMessageI.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, AQMessageI.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setTypeDescriptor(TypeDescriptor typeDescriptor) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _sd;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, AQMessageI.class, $$$methodRef$$$1, this, typeDescriptor);
            }
            this.sd = _sd;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, AQMessageI.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, AQMessageI.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, AQMessageI.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] getMessageId() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, AQMessageI.class, $$$methodRef$$$2, this, new Object[0]);
            }
            byte[] byArray = this.id;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, AQMessageI.class, $$$methodRef$$$2, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, AQMessageI.class, $$$methodRef$$$2, this, null);
            }
            return this.id;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, AQMessageI.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setMessageId(byte[] byArray) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _id;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, AQMessageI.class, $$$methodRef$$$3, this, new Object[]{byArray});
            }
            this.id = _id;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, AQMessageI.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, AQMessageI.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, AQMessageI.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public AQMessageProperties getMessageProperties() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, AQMessageI.class, $$$methodRef$$$4, this, new Object[0]);
            }
            AQMessagePropertiesI aQMessagePropertiesI = this.properties;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, AQMessageI.class, $$$methodRef$$$4, this, aQMessagePropertiesI);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, AQMessageI.class, $$$methodRef$$$4, this, null);
            }
            return aQMessagePropertiesI;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, AQMessageI.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    AQMessagePropertiesI getMessagePropertiesI() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, AQMessageI.class, $$$methodRef$$$5, this, new Object[0]);
            }
            AQMessagePropertiesI aQMessagePropertiesI = this.properties;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, AQMessageI.class, $$$methodRef$$$5, this, aQMessagePropertiesI);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, AQMessageI.class, $$$methodRef$$$5, this, null);
            }
            return aQMessagePropertiesI;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, AQMessageI.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPayload(byte[] byArray) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _payload;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, AQMessageI.class, $$$methodRef$$$6, this, new Object[]{byArray});
            }
            this.payload = _payload;
            this.toid = TypeDescriptor.RAWTOID;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, AQMessageI.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, AQMessageI.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, AQMessageI.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPayload(byte[] byArray, byte[] byArray2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _toid;
            void _payload;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, AQMessageI.class, $$$methodRef$$$7, this, byArray, byArray2);
            }
            this.payload = _payload;
            this.toid = _toid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, AQMessageI.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, AQMessageI.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, AQMessageI.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPayload(Struct struct) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _payload;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, AQMessageI.class, $$$methodRef$$$8, this, struct);
            }
            if (!$assertionsDisabled && !(_payload instanceof OracleStruct)) {
                AssertionError assertionError = new AssertionError((Object)("_payload is " + _payload));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, AQMessageI.class, $$$methodRef$$$8, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.payload = ((OracleStruct)_payload).toBytes();
            this.payLoadStruct = (OracleStruct)_payload;
            this.toid = ((OracleStruct)_payload).getDescriptor().getOracleTypeADT().getTOID();
            this.version = ((OracleStruct)_payload).getDescriptor().getOracleTypeADT().getTypeVersion();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, AQMessageI.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, AQMessageI.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, AQMessageI.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPayload(STRUCT sTRUCT) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _payload;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, AQMessageI.class, $$$methodRef$$$9, this, sTRUCT);
            }
            this.payload = _payload.toBytes();
            this.payLoadStruct = _payload;
            this.toid = _payload.getDescriptor().getOracleTypeADT().getTOID();
            this.version = _payload.getDescriptor().getOracleTypeADT().getTypeVersion();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, AQMessageI.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, AQMessageI.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, AQMessageI.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPayload(ANYDATA aNYDATA) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _payload;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, AQMessageI.class, $$$methodRef$$$10, this, aNYDATA);
            }
            this.payload = _payload.toDatum(this.conn).shareBytes();
            this.payLoadANYDATA = _payload;
            this.toid = TypeDescriptor.ANYDATATOID;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, AQMessageI.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, AQMessageI.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, AQMessageI.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPayload(RAW rAW) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _payload;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, AQMessageI.class, $$$methodRef$$$11, this, rAW);
            }
            this.payload = _payload.shareBytes();
            this.payLoadRAW = _payload;
            this.toid = TypeDescriptor.RAWTOID;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, AQMessageI.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, AQMessageI.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, AQMessageI.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPayload(XMLType xMLType) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _payload;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, AQMessageI.class, $$$methodRef$$$12, this, xMLType);
            }
            this.payload = _payload.toBytes();
            this.payLoadXMLType = _payload;
            this.toid = TypeDescriptor.XMLTYPETOID;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, AQMessageI.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, AQMessageI.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, AQMessageI.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPayload(OracleJsonDatum oracleJsonDatum) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void jsonPayload;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, AQMessageI.class, $$$methodRef$$$13, this, oracleJsonDatum);
            }
            this.payload = jsonPayload.shareBytes();
            this.payloadJson = jsonPayload;
            this.toid = TypeDescriptor.JSONTOID;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, AQMessageI.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, AQMessageI.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, AQMessageI.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] getPayload() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, AQMessageI.class, $$$methodRef$$$14, this, new Object[0]);
            }
            byte[] byArray = this.payload;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, AQMessageI.class, $$$methodRef$$$14, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, AQMessageI.class, $$$methodRef$$$14, this, null);
            }
            return this.payload;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, AQMessageI.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public RAW getRAWPayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, AQMessageI.class, $$$methodRef$$$15, this, new Object[0]);
            }
            RAW ret = null;
            if (this.payLoadRAW != null) {
                ret = this.payLoadRAW;
            } else if (this.isRAWPayload()) {
                ret = this.payLoadRAW = new RAW(this.payload);
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, AQMessageI.class, $$$methodRef$$$15, this, sQLException);
                }
                throw sQLException;
            }
            RAW rAW = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, AQMessageI.class, $$$methodRef$$$15, this, rAW);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, AQMessageI.class, $$$methodRef$$$15, this, null);
            }
            return rAW;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, AQMessageI.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isRAWPayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, AQMessageI.class, $$$methodRef$$$16, this, new Object[0]);
            }
            if (this.toid == null || this.toid.length != 16) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, AQMessageI.class, $$$methodRef$$$16, this, sQLException);
                }
                throw sQLException;
            }
            if (AQMessageI.compareToid(this.toid, TypeDescriptor.RAWTOID)) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, AQMessageI.class, $$$methodRef$$$16, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, AQMessageI.class, $$$methodRef$$$16, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, AQMessageI.class, $$$methodRef$$$16, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, AQMessageI.class, $$$methodRef$$$16, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, AQMessageI.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleJsonDatum getJSONPayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, AQMessageI.class, $$$methodRef$$$17, this, new Object[0]);
            }
            OracleJsonDatum ret = null;
            if (this.payloadJson != null) {
                ret = this.payloadJson;
            } else if (this.isJSONPayload()) {
                ret = this.payloadJson = new OracleJsonDatum(this.payload);
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, AQMessageI.class, $$$methodRef$$$17, this, sQLException);
                }
                throw sQLException;
            }
            OracleJsonDatum oracleJsonDatum = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, AQMessageI.class, $$$methodRef$$$17, this, oracleJsonDatum);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, AQMessageI.class, $$$methodRef$$$17, this, null);
            }
            return oracleJsonDatum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, AQMessageI.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isJSONPayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, AQMessageI.class, $$$methodRef$$$18, this, new Object[0]);
            }
            if (this.toid == null || this.toid.length != 16) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, AQMessageI.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            boolean bl2 = AQMessageI.compareToid(this.toid, TypeDescriptor.JSONTOID);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, AQMessageI.class, $$$methodRef$$$18, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, AQMessageI.class, $$$methodRef$$$18, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, AQMessageI.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Struct getStructPayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, AQMessageI.class, $$$methodRef$$$19, this, new Object[0]);
            }
            STRUCT sTRUCT = this.getSTRUCTPayload();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, AQMessageI.class, $$$methodRef$$$19, this, sTRUCT);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, AQMessageI.class, $$$methodRef$$$19, this, null);
            }
            return sTRUCT;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, AQMessageI.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public STRUCT getSTRUCTPayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, AQMessageI.class, $$$methodRef$$$20, this, new Object[0]);
            }
            STRUCT ret = null;
            if (!this.isSTRUCTPayload()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, AQMessageI.class, $$$methodRef$$$20, this, sQLException);
                }
                throw sQLException;
            }
            if (this.payLoadStruct != null) {
                ret = this.payLoadStruct instanceof STRUCT ? (STRUCT)this.payLoadStruct : (STRUCT)((TxnReplayableStruct)((Object)this.payLoadStruct)).getDelegateStruct();
            } else {
                if (this.sd == null) {
                    this.typeName = OracleTypeADT.toid2typename(this.conn, this.toid);
                    this.sd = TypeDescriptor.getTypeDescriptor(this.typeName, (OracleConnection)this.conn);
                }
                if (this.sd instanceof StructDescriptor) {
                    ret = new STRUCT((StructDescriptor)this.sd, this.payload, this.conn);
                    this.payLoadStruct = ret;
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, AQMessageI.class, $$$methodRef$$$20, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            STRUCT sTRUCT = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, AQMessageI.class, $$$methodRef$$$20, this, sTRUCT);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, AQMessageI.class, $$$methodRef$$$20, this, null);
            }
            return sTRUCT;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, AQMessageI.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isSTRUCTPayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, AQMessageI.class, $$$methodRef$$$21, this, new Object[0]);
            }
            if (this.toid == null || this.toid.length != 16) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, AQMessageI.class, $$$methodRef$$$21, this, sQLException);
                }
                throw sQLException;
            }
            boolean isObjectPayload = true;
            boolean allzero = true;
            for (int i2 = 0; i2 < 15; ++i2) {
                if (this.toid[i2] == 0) continue;
                allzero = false;
                break;
            }
            if (allzero || this.isRAWPayload() || this.isANYDATAPayload()) {
                isObjectPayload = false;
            }
            boolean bl2 = isObjectPayload;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, AQMessageI.class, $$$methodRef$$$21, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, AQMessageI.class, $$$methodRef$$$21, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, AQMessageI.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ANYDATA getANYDATAPayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, AQMessageI.class, $$$methodRef$$$22, this, new Object[0]);
            }
            ANYDATA ret = null;
            if (this.payLoadANYDATA != null) {
                ret = this.payLoadANYDATA;
            } else if (this.isANYDATAPayload()) {
                OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", this.conn);
                OPAQUE opq = new OPAQUE(desc, this.payload, this.conn);
                ret = this.payLoadANYDATA = new ANYDATA(opq);
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, AQMessageI.class, $$$methodRef$$$22, this, sQLException);
                }
                throw sQLException;
            }
            ANYDATA aNYDATA = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, AQMessageI.class, $$$methodRef$$$22, this, aNYDATA);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, AQMessageI.class, $$$methodRef$$$22, this, null);
            }
            return aNYDATA;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, AQMessageI.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isANYDATAPayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, AQMessageI.class, $$$methodRef$$$23, this, new Object[0]);
            }
            if (this.toid == null || this.toid.length != 16) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, AQMessageI.class, $$$methodRef$$$23, this, sQLException);
                }
                throw sQLException;
            }
            if (this.typeName != null && this.typeName.equals("SYS.ANYDATA") || AQMessageI.compareToid(this.toid, TypeDescriptor.ANYDATATOID)) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, AQMessageI.class, $$$methodRef$$$23, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, AQMessageI.class, $$$methodRef$$$23, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, AQMessageI.class, $$$methodRef$$$23, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, AQMessageI.class, $$$methodRef$$$23, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, AQMessageI.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public XMLType getXMLTypePayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, AQMessageI.class, $$$methodRef$$$24, this, new Object[0]);
            }
            XMLType ret = null;
            if (this.payLoadXMLType != null) {
                ret = this.payLoadXMLType;
            } else if (this.isXMLTypePayload()) {
                OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor("SYS.XMLTYPE", this.conn);
                OPAQUE opq = new OPAQUE(desc, this.payload, this.conn);
                ret = this.payLoadXMLType = XMLType.createXML((OPAQUE)opq);
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, AQMessageI.class, $$$methodRef$$$24, this, sQLException);
                }
                throw sQLException;
            }
            XMLType xMLType = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, AQMessageI.class, $$$methodRef$$$24, this, xMLType);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, AQMessageI.class, $$$methodRef$$$24, this, null);
            }
            return xMLType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, AQMessageI.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isXMLTypePayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, AQMessageI.class, $$$methodRef$$$25, this, new Object[0]);
            }
            if (this.toid == null || this.toid.length != 16) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, AQMessageI.class, $$$methodRef$$$25, this, sQLException);
                }
                throw sQLException;
            }
            if (this.typeName != null && this.typeName.equals("SYS.XMLTYPE") || AQMessageI.compareToid(this.toid, TypeDescriptor.XMLTYPETOID)) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, AQMessageI.class, $$$methodRef$$$25, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, AQMessageI.class, $$$methodRef$$$25, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, AQMessageI.class, $$$methodRef$$$25, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, AQMessageI.class, $$$methodRef$$$25, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, AQMessageI.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] getPayloadTOID() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, AQMessageI.class, $$$methodRef$$$26, this, new Object[0]);
            }
            byte[] byArray = this.toid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, AQMessageI.class, $$$methodRef$$$26, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, AQMessageI.class, $$$methodRef$$$26, this, null);
            }
            return this.toid;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, AQMessageI.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getPayloadVersion() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, AQMessageI.class, $$$methodRef$$$27, this, new Object[0]);
            }
            int n2 = this.version;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, AQMessageI.class, $$$methodRef$$$27, this, n2);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, AQMessageI.class, $$$methodRef$$$27, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, AQMessageI.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean compareToid(byte[] byArray, byte[] byArray2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] toid;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, AQMessageI.class, $$$methodRef$$$28, null, byArray, byArray2);
            }
            boolean ret = false;
            if (toid != null) {
                void toid2;
                if (toid == toid2) {
                    ret = true;
                } else if (toid.length == ((void)toid2).length) {
                    boolean identical = true;
                    for (int i2 = 0; i2 < toid.length; ++i2) {
                        if (toid[i2] == toid2[i2]) continue;
                        identical = false;
                        break;
                    }
                    if (identical) {
                        ret = true;
                    }
                }
            }
            boolean bl2 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, AQMessageI.class, $$$methodRef$$$28, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, AQMessageI.class, $$$methodRef$$$28, null, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, AQMessageI.class, $$$methodRef$$$28, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DisableTrace
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Message Properties={");
        sb.append(this.properties);
        sb.append("} ");
        return sb.toString();
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, AQMessageI.class, $$$methodRef$$$29, this, new Object[0]);
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, AQMessageI.class, $$$methodRef$$$29, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, AQMessageI.class, $$$methodRef$$$29, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, AQMessageI.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$31 = AQMessageI.class.getDeclaredConstructor(AQMessagePropertiesI.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = AQMessageI.class.getDeclaredConstructor(AQMessagePropertiesI.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = AQMessageI.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = AQMessageI.class.getDeclaredMethod("compareToid", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = AQMessageI.class.getDeclaredMethod("getPayloadVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = AQMessageI.class.getDeclaredMethod("getPayloadTOID", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = AQMessageI.class.getDeclaredMethod("isXMLTypePayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = AQMessageI.class.getDeclaredMethod("getXMLTypePayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = AQMessageI.class.getDeclaredMethod("isANYDATAPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = AQMessageI.class.getDeclaredMethod("getANYDATAPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = AQMessageI.class.getDeclaredMethod("isSTRUCTPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = AQMessageI.class.getDeclaredMethod("getSTRUCTPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = AQMessageI.class.getDeclaredMethod("getStructPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = AQMessageI.class.getDeclaredMethod("isJSONPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = AQMessageI.class.getDeclaredMethod("getJSONPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = AQMessageI.class.getDeclaredMethod("isRAWPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = AQMessageI.class.getDeclaredMethod("getRAWPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = AQMessageI.class.getDeclaredMethod("getPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = AQMessageI.class.getDeclaredMethod("setPayload", OracleJsonDatum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = AQMessageI.class.getDeclaredMethod("setPayload", XMLType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = AQMessageI.class.getDeclaredMethod("setPayload", RAW.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = AQMessageI.class.getDeclaredMethod("setPayload", ANYDATA.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = AQMessageI.class.getDeclaredMethod("setPayload", STRUCT.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = AQMessageI.class.getDeclaredMethod("setPayload", Struct.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = AQMessageI.class.getDeclaredMethod("setPayload", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = AQMessageI.class.getDeclaredMethod("setPayload", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = AQMessageI.class.getDeclaredMethod("getMessagePropertiesI", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = AQMessageI.class.getDeclaredMethod("getMessageProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = AQMessageI.class.getDeclaredMethod("setMessageId", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = AQMessageI.class.getDeclaredMethod("getMessageId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = AQMessageI.class.getDeclaredMethod("setTypeDescriptor", TypeDescriptor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AQMessageI.class.getDeclaredMethod("setTypeName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

