/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.common;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class LoadCExtException
extends Exception {
    private static final long serialVersionUID = 3517291912314595890L;
    protected final transient TruffleString formatString;
    protected final transient Object[] formatArgs;

    protected LoadCExtException(TruffleString formatString, Object[] formatArgs) {
        super(null, null);
        this.formatString = formatString;
        this.formatArgs = formatArgs;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public static final class ImportException
    extends LoadCExtException {
        private static final long serialVersionUID = 7862376523476548L;
        private final PException cause;
        private final transient TruffleString name;
        private final transient Object path;

        public ImportException(PException cause, TruffleString name, TruffleString path, TruffleString formatString, Object ... formatArgs) {
            super(formatString, formatArgs);
            this.cause = cause;
            this.name = name;
            this.path = path;
        }

        public PException reraise(VirtualFrame frame, Node inliningTarget, PConstructAndRaiseNode.Lazy raiseNode) {
            if (this.cause != null) {
                throw raiseNode.get(inliningTarget).raiseImportErrorWithModuleAndCause((Frame)frame, this.cause.getEscapedException(), this.name, this.path, this.formatString, this.formatArgs);
            }
            throw raiseNode.get(inliningTarget).raiseImportErrorWithModule((Frame)frame, this.name, this.path, this.formatString, this.formatArgs);
        }
    }

    public static final class ApiInitException
    extends LoadCExtException {
        private static final long serialVersionUID = 982734876234786L;
        private final Exception cause;

        public ApiInitException(Exception cause) {
            super((TruffleString)null, (Object[])null);
            this.cause = cause;
        }

        public ApiInitException(TruffleString formatString, Object ... formatArgs) {
            super(formatString, formatArgs);
            this.cause = null;
        }

        public PException reraise(VirtualFrame frame, Node inliningTarget, PConstructAndRaiseNode.Lazy raiseNode) {
            Exception exception = this.cause;
            if (exception instanceof PException) {
                PException pcause = (PException)((Object)exception);
                throw pcause.getExceptionForReraise(false);
            }
            if (this.cause != null) {
                throw raiseNode.get(inliningTarget).executeWithFmtMessageAndArgs((Frame)frame, PythonBuiltinClassType.SystemError, ErrorMessages.M, new Object[]{this.cause}, null);
            }
            throw raiseNode.get(inliningTarget).executeWithFmtMessageAndArgs((Frame)frame, PythonBuiltinClassType.SystemError, this.formatString, this.formatArgs, null);
        }
    }
}

