# Serialise
<span class="source-link">[[Source]](src/serialise/serialise.md#L-0-43)</span>
```pony
primitive val Serialise
```

## Constructors

### create
<span class="source-link">[[Source]](src/serialise/serialise.md#L-0-43)</span>


```pony
new val create()
: Serialise val^
```

#### Returns

* [Serialise](serialise-Serialise.md) val^

---

## Public Functions

### signature
<span class="source-link">[[Source]](src/serialise/serialise.md#L-0-44)</span>


Returns a byte array that is unique to this compiled Pony binary, for the
purposes of comparing before deserialising any data from that source.
It is statistically impossible for two serialisation-incompatible Pony
binaries to have the same serialise signature.


```pony
fun box signature()
: Array[U8 val] val
```

#### Returns

* [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] val

---

### eq
<span class="source-link">[[Source]](src/serialise/serialise.md#L-0-44)</span>


```pony
fun box eq(
  that: Serialise val)
: Bool val
```
#### Parameters

*   that: [Serialise](serialise-Serialise.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/serialise/serialise.md#L-0-44)</span>


```pony
fun box ne(
  that: Serialise val)
: Bool val
```
#### Parameters

*   that: [Serialise](serialise-Serialise.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

