/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedKDFOperatorFactory;
import org.bouncycastle.crypto.general.SCryptImpl;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.util.Arrays;

public final class KDF {
    public static final ScryptParametersBuilder SCRYPT = new ScryptParametersBuilder(new GeneralAlgorithm("SCrypt"));

    private KDF() {
    }

    public static final class SCryptFactory
    extends GuardedKDFOperatorFactory<ScryptParameters> {
        @Override
        public KDFCalculator createKDFCalculator(final ScryptParameters scryptParameters) {
            return new KDFCalculator(){

                public ScryptParameters getParameters() {
                    Utils.approveModeCheck(SCRYPT.getAlgorithm());
                    return scryptParameters;
                }

                @Override
                public void generateBytes(byte[] byArray) {
                    Utils.approveModeCheck(SCRYPT.getAlgorithm());
                    byte[] byArray2 = SCryptImpl.generate(scryptParameters.seed, scryptParameters.salt, scryptParameters.n, scryptParameters.r, scryptParameters.p, byArray.length);
                    System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                    Arrays.fill(byArray2, (byte)0);
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    Utils.approveModeCheck(SCRYPT.getAlgorithm());
                    byte[] byArray2 = SCryptImpl.generate(scryptParameters.seed, scryptParameters.salt, scryptParameters.n, scryptParameters.r, scryptParameters.p, n2);
                    System.arraycopy(byArray2, 0, byArray, n, n2);
                    Arrays.fill(byArray2, (byte)0);
                }
            };
        }
    }

    public static final class ScryptParameters
    extends GeneralParameters<GeneralAlgorithm> {
        final int n;
        final int r;
        final int p;
        final byte[] salt;
        final byte[] seed;

        private ScryptParameters(int n, byte[] byArray, int n2, int n3, byte[] byArray2) {
            super(SCRYPT.getAlgorithm());
            this.seed = byArray;
            this.n = n;
            this.r = n2;
            this.p = n3;
            this.salt = byArray2;
        }
    }

    public static final class ScryptParametersBuilder
    extends GeneralParameters<GeneralAlgorithm> {
        ScryptParametersBuilder(GeneralAlgorithm generalAlgorithm) {
            super(generalAlgorithm);
        }

        public ScryptParameters using(byte[] byArray, int n, int n2, int n3, byte[] byArray2) {
            return new ScryptParameters(n, Arrays.clone(byArray2), n2, n3, Arrays.clone(byArray));
        }

        public ScryptParameters using(byte[] byArray, int n, int n2, int n3, PasswordConverter passwordConverter, char[] cArray) {
            return new ScryptParameters(n, passwordConverter.convert(cArray), n2, n3, Arrays.clone(byArray));
        }
    }
}

