/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.nodes.ReloadSecureSettingsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class ReloadSecureSettingsRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ReloadSecureSettingsRequest> {
    @Nonnull
    private final List<String> nodeId;
    @Nullable
    private final String secureSettingsPassword;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<ReloadSecureSettingsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReloadSecureSettingsRequest::setupReloadSecureSettingsRequestDeserializer);
    public static final Endpoint<ReloadSecureSettingsRequest, ReloadSecureSettingsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ReloadSecureSettingsRequest, ReloadSecureSettingsResponse>(request -> "POST", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_nodes/reload_secure_settings";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            buf.append("/reload_secure_settings");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, ReloadSecureSettingsResponse._DESERIALIZER);

    private ReloadSecureSettingsRequest(Builder builder) {
        super(builder);
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.secureSettingsPassword = builder.secureSettingsPassword;
        this.timeout = builder.timeout;
    }

    public static ReloadSecureSettingsRequest of(Function<Builder, ObjectBuilder<ReloadSecureSettingsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final String secureSettingsPassword() {
        return this.secureSettingsPassword;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.secureSettingsPassword != null) {
            generator.writeKey("secure_settings_password");
            generator.write(this.secureSettingsPassword);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupReloadSecureSettingsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::secureSettingsPassword, JsonpDeserializer.stringDeserializer(), "secure_settings_password");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.nodeId);
        result = 31 * result + Objects.hashCode(this.secureSettingsPassword);
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReloadSecureSettingsRequest other = (ReloadSecureSettingsRequest)o;
        return Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.secureSettingsPassword, other.secureSettingsPassword) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ReloadSecureSettingsRequest> {
        @Nullable
        private List<String> nodeId;
        @Nullable
        private String secureSettingsPassword;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(ReloadSecureSettingsRequest o) {
            super(o);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.secureSettingsPassword = o.secureSettingsPassword;
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.secureSettingsPassword = o.secureSettingsPassword;
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        @Nonnull
        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        @Nonnull
        public final Builder secureSettingsPassword(@Nullable String value) {
            this.secureSettingsPassword = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public ReloadSecureSettingsRequest build() {
            this._checkSingleUse();
            return new ReloadSecureSettingsRequest(this);
        }
    }
}

