/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.BaseWritableBufferImpl;
import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.MapWritableBufferImpl;
import com.yahoo.memory.NonNativeWritableBufferImpl;
import com.yahoo.memory.StepBoolean;
import com.yahoo.memory.Util;
import java.nio.ByteOrder;

final class MapNonNativeWritableBufferImpl
extends NonNativeWritableBufferImpl {
    private static final int id = 112;
    private final long nativeBaseOffset;
    private final StepBoolean valid;
    private final byte typeId;

    MapNonNativeWritableBufferImpl(long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, StepBoolean valid, BaseWritableMemoryImpl originMemory) {
        super(null, nativeBaseOffset, regionOffset, capacityBytes, originMemory);
        this.nativeBaseOffset = nativeBaseOffset;
        this.valid = valid;
        this.typeId = (byte)(0x70 | typeId & 7);
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = 2 | (readOnly ? 1 : 0);
        return Util.isNativeOrder(byteOrder) ? new MapWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.originMemory) : new MapNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.originMemory);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int type = 4 | (readOnly ? 1 : 0);
        return Util.isNativeOrder(byteOrder) ? new MapWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.originMemory) : new MapNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.originMemory);
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }
}

