/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.constant.ForecastCommonMessages;
import org.opensearch.forecast.transport.DeleteForecastModelAction;
import org.opensearch.forecast.transport.StopForecasterAction;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.common.exception.InternalFailure;
import org.opensearch.timeseries.transport.DeleteModelRequest;
import org.opensearch.timeseries.transport.StopConfigRequest;
import org.opensearch.timeseries.transport.StopConfigResponse;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class StopForecasterTransportAction
extends HandledTransportAction<ActionRequest, StopConfigResponse> {
    private static final Logger LOG = LogManager.getLogger(StopForecasterTransportAction.class);
    private final Client client;
    private final DiscoveryNodeFilterer nodeFilter;

    @Inject
    public StopForecasterTransportAction(TransportService transportService, DiscoveryNodeFilterer nodeFilter, ActionFilters actionFilters, Client client) {
        super(StopForecasterAction.NAME, transportService, actionFilters, StopConfigRequest::new);
        this.client = client;
        this.nodeFilter = nodeFilter;
    }

    protected void doExecute(Task task, ActionRequest actionRequest, ActionListener<StopConfigResponse> listener) {
        StopConfigRequest request = StopConfigRequest.fromActionRequest(actionRequest);
        String configId = request.getConfigID();
        try {
            DiscoveryNode[] dataNodes = this.nodeFilter.getEligibleDataNodes();
            DeleteModelRequest modelDeleteRequest = new DeleteModelRequest(configId, dataNodes);
            this.client.execute((ActionType)DeleteForecastModelAction.INSTANCE, (ActionRequest)modelDeleteRequest, ActionListener.wrap(response -> {
                if (response.hasFailures()) {
                    LOG.warn("Cannot delete all models of forecaster {}", (Object)configId);
                    for (FailedNodeException failedNodeException : response.failures()) {
                        LOG.warn("Deleting models of node has exception", (Throwable)failedNodeException);
                    }
                    listener.onResponse((Object)new StopConfigResponse(false));
                } else {
                    LOG.info("models of forecaster {} get deleted", (Object)configId);
                    listener.onResponse((Object)new StopConfigResponse(true));
                }
            }, exception -> {
                LOG.error((Message)new ParameterizedMessage("Deletion of forecaster [{}] has exception.", (Object)configId), (Throwable)exception);
                listener.onResponse((Object)new StopConfigResponse(false));
            }));
        }
        catch (Exception e) {
            LOG.error(ForecastCommonMessages.FAIL_TO_STOP_FORECASTER + " " + configId, (Throwable)e);
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            listener.onFailure((Exception)new InternalFailure(configId, ForecastCommonMessages.FAIL_TO_STOP_FORECASTER, cause));
        }
    }
}

