/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedMediaType;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedContent
implements ComposedChanged {
    private final Content oldContent;
    private final Content newContent;
    private final DiffContext context;
    private Map<String, MediaType> increased;
    private Map<String, MediaType> missing;
    private Map<String, ChangedMediaType> changed;

    public ChangedContent(Content oldContent, Content newContent, DiffContext context) {
        this.oldContent = oldContent;
        this.newContent = newContent;
        this.context = context;
        this.increased = new LinkedHashMap<String, MediaType>();
        this.missing = new LinkedHashMap<String, MediaType>();
        this.changed = new LinkedHashMap<String, ChangedMediaType>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return new ArrayList<Changed>(this.changed.values());
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.increased.isEmpty() && this.missing.isEmpty()) {
            return DiffResult.NO_CHANGES;
        }
        if (!this.missing.isEmpty()) {
            if (this.context.isRequest() && BackwardIncompatibleProp.REQUEST_CONTENT_DECREASED.enabled(this.context, new Object[0])) {
                return DiffResult.INCOMPATIBLE;
            }
            if (this.context.isResponse() && BackwardIncompatibleProp.RESPONSE_CONTENT_DECREASED.enabled(this.context, new Object[0])) {
                return DiffResult.INCOMPATIBLE;
            }
        }
        return DiffResult.COMPATIBLE;
    }

    public Content getOldContent() {
        return this.oldContent;
    }

    public Content getNewContent() {
        return this.newContent;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public Map<String, MediaType> getIncreased() {
        return this.increased;
    }

    public Map<String, MediaType> getMissing() {
        return this.missing;
    }

    public Map<String, ChangedMediaType> getChanged() {
        return this.changed;
    }

    public ChangedContent setIncreased(Map<String, MediaType> increased) {
        this.increased = increased;
        return this;
    }

    public ChangedContent setMissing(Map<String, MediaType> missing) {
        this.missing = missing;
        return this;
    }

    public ChangedContent setChanged(Map<String, ChangedMediaType> changed) {
        this.changed = changed;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedContent that = (ChangedContent)o;
        return Objects.equals(this.oldContent, that.oldContent) && Objects.equals(this.newContent, that.newContent) && Objects.equals(this.context, that.context) && Objects.equals(this.increased, that.increased) && Objects.equals(this.missing, that.missing) && Objects.equals(this.changed, that.changed);
    }

    public int hashCode() {
        return Objects.hash(this.oldContent, this.newContent, this.context, this.increased, this.missing, this.changed);
    }

    public String toString() {
        return "ChangedContent(oldContent=" + this.getOldContent() + ", newContent=" + this.getNewContent() + ", context=" + this.getContext() + ", increased=" + this.getIncreased() + ", missing=" + this.getMissing() + ", changed=" + this.getChanged() + ")";
    }
}

