from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, ForeignKey, String, Boolean, Double
from sqlalchemy.orm import relationship

from ..base import Base


class RegionIssues(Base):
    __tablename__ = 'region_issues'
    id = Column(Integer, primary_key=True, index=True)
    category = Column(String, default='')
    health_string = Column(String, default='')
    health_value = Column(Double, default=0.0)
    sub_category = Column(String, default=None, nullable=True)
    is_priority = Column(Boolean, default=False)

    region_id = Column(Integer, ForeignKey('region.id'))
    region = relationship('Region', back_populates='region_issues')


class RegionIssuesShortInDB(BaseModel):
    category: str

    class Config:
        from_attributes = True


class RegionIssuesInDB(RegionIssuesShortInDB):
    health_string: str
    health_value: float
    sub_category: Optional[str]
    is_priority: bool

    class Config:
        from_attributes = True


class RegionIssuesCreate(BaseModel):
    id: Optional[int] = None
    category: str
    health_string: str
    health_value: float
    sub_category: Optional[str]
    is_priority: bool

    class Config:
        from_attributes = True
