/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class CssHelpResolver {
    private static CssHelpResolver INSTANCE = new CssHelpResolver("org/netbeans/modules/css/resources/css_property_help");
    private static Pattern NAV_BAR = Pattern.compile("<div\\s+class\\s*=\\s*\"navbar\"", 8);
    private Pattern END_SEARCH = Pattern.compile("<[hH][1-5]>|<a\\s+name=\"propdef-", 8);
    private Pattern PROP_DEF_PATTERN = Pattern.compile("<div\\s+class\\s*=\\s*\"propdef\"");
    private static final String HELP_LOCATION = "docs/css21-spec.zip";
    private static URL HELP_ZIP_URL;
    private WeakHashMap<String, String> pages_cache = new WeakHashMap();
    private Map<String, PropertyDescriptor> properties;

    public static CssHelpResolver instance() {
        return INSTANCE;
    }

    private CssHelpResolver(String sourcePath) {
        this.parseSource(sourcePath);
    }

    public String getPropertyHelp(String propertyName) {
        URL helpURL = this.getPropertyHelpURL(propertyName);
        if (helpURL == null) {
            return null;
        }
        return this.getHelpText(helpURL);
    }

    private String getHelpText(URL url) {
        int firstLineEnd;
        String anchor_part;
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        String file_content = this.pages_cache.get(path);
        if (file_content == null) {
            try {
                ByteArrayOutputStream baos;
                try (InputStream is = url.openStream();){
                    byte[] buffer = new byte[1000];
                    baos = new ByteArrayOutputStream();
                    int count = 0;
                    do {
                        if ((count = is.read(buffer)) <= 0) continue;
                        baos.write(buffer, 0, count);
                    } while (count > 0);
                }
                file_content = baos.toString();
                baos.close();
            }
            catch (IOException e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Cannot read css help file.", e);
            }
            this.pages_cache.put(path, file_content);
        }
        String anchor = url.getRef();
        Pattern start_search = Pattern.compile("^.*<a\\s+name=\"" + anchor + "\".*$", 8);
        Matcher matcher = start_search.matcher(file_content);
        int start_index = 0;
        int begin_end_search_from = 0;
        if (matcher.find()) {
            start_index = matcher.start();
            begin_end_search_from = matcher.end();
        }
        start_index = this.findSectionStart(start_index, file_content);
        int end_index = file_content.length();
        matcher = this.END_SEARCH.matcher(file_content.subSequence(begin_end_search_from, file_content.length()));
        if (matcher.find()) {
            end_index = matcher.start() + begin_end_search_from;
        }
        if ((matcher = NAV_BAR.matcher(anchor_part = file_content.substring(start_index, end_index))).find()) {
            anchor_part = anchor_part.substring(0, matcher.start());
        }
        if ((firstLineEnd = anchor_part.indexOf("\n")) > 0) {
            String firstLine = anchor_part.substring(0, firstLineEnd);
            firstLine = firstLine.replace("<strong>'", "<strong style=\"font-size: large\">");
            firstLine = firstLine.replace("'</strong>", "</strong>");
            anchor_part = firstLine + anchor_part.substring(firstLineEnd + 1);
        }
        return anchor_part;
    }

    public URL getPropertyHelpURL(String propertyName) {
        String hzurl = CssHelpResolver.getHelpZIPURLasString();
        if (hzurl == null) {
            return null;
        }
        PropertyDescriptor pd = this.getPD(propertyName);
        if (pd == null) {
            return null;
        }
        try {
            return new URL(hzurl + pd.helpLink);
        }
        catch (MalformedURLException ex) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error creating URL for property " + propertyName, ex);
            return null;
        }
    }

    private PropertyDescriptor getPD(String propertyName) {
        return this.properties.get(propertyName.toLowerCase());
    }

    private int findSectionStart(int startIndex, String fileContent) {
        int index;
        for (index = startIndex; index >= 0; --index) {
            char next;
            char ch = fileContent.charAt(index);
            if (ch != '<' || (next = fileContent.charAt(index + 1)) != 'h' && next != 'H' || !Character.isDigit(fileContent.charAt(index + 2))) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(ch);
            builder.append(next);
            builder.append("\\d");
            builder.append('>');
            Pattern pattern = Pattern.compile(builder.toString());
            Matcher matcher = pattern.matcher(fileContent);
            if (matcher.find(index)) break;
        }
        if (index > 0) {
            String beggining = fileContent.substring(index, startIndex);
            Matcher matcher = this.PROP_DEF_PATTERN.matcher(beggining);
            int matchIndex = 0;
            while (matcher.find()) {
                matchIndex = matcher.start();
            }
            return index + matchIndex;
        }
        return startIndex;
    }

    private void parseSource(String sourcePath) {
        ResourceBundle bundle = NbBundle.getBundle((String)sourcePath);
        this.properties = new HashMap<String, PropertyDescriptor>();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String helpLink = keys.nextElement();
            int propertyNameIdx = helpLink.indexOf(45);
            String propertyName = helpLink.substring(propertyNameIdx + 1);
            String value = bundle.getString(helpLink);
            StringTokenizer st = new StringTokenizer(value, ";");
            HashMap<String, String> valueToLink = new HashMap<String, String>();
            while (st.hasMoreTokens()) {
                String val = st.nextToken();
                int propertyValueIdx = helpLink.indexOf(45);
                String valueName = helpLink.substring(propertyValueIdx + 1);
                valueToLink.put(valueName, val);
            }
            PropertyDescriptor pd = new PropertyDescriptor(propertyName, helpLink, valueToLink);
            this.properties.put(propertyName, pd);
        }
    }

    public static synchronized String getHelpZIPURLasString() {
        return CssHelpResolver.getHelpZIPURL() == null ? null : CssHelpResolver.getHelpZIPURL().toString();
    }

    public static synchronized URL getHelpZIPURL() {
        if (HELP_ZIP_URL == null) {
            File f = InstalledFileLocator.getDefault().locate(HELP_LOCATION, null, false);
            if (f != null) {
                try {
                    URL urll = f.toURI().toURL();
                    HELP_ZIP_URL = FileUtil.getArchiveRoot((URL)urll);
                }
                catch (MalformedURLException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            } else {
                Logger.getLogger(CssHelpResolver.class.getSimpleName()).info("Cannot locate the css documentation file docs/css21-spec.zip");
            }
        }
        return HELP_ZIP_URL;
    }

    private static class PropertyDescriptor {
        String propertyName;
        String helpLink;
        Map<String, String> values;

        private PropertyDescriptor(String propertyName, String helpLink, Map<String, String> values) {
            this.propertyName = propertyName;
            this.helpLink = helpLink;
            this.values = values;
        }
    }
}

