/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class BugzillaSearch {
    private final List<Entry> parameters = new ArrayList<Entry>();

    public BugzillaSearch(TaskRepository repository, String queryUrl) throws UnsupportedEncodingException {
        String[] options;
        queryUrl = queryUrl.substring(queryUrl.indexOf("?") + 1);
        String[] stringArray = options = queryUrl.split("&");
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            int endindex = option.indexOf("=");
            String key = endindex == -1 ? null : option.substring(0, option.indexOf("="));
            if (key != null) {
                String value = URLDecoder.decode(option.substring(option.indexOf("=") + 1), repository.getCharacterEncoding());
                this.parameters.add(new Entry(key, value));
            }
            ++n2;
        }
    }

    public List<Entry> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public List<Entry> getParameters(String key) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        for (Entry entry : this.parameters) {
            if (!entry.key.equals(key)) continue;
            result.add(entry);
        }
        return Collections.unmodifiableList(result);
    }

    public static class Entry {
        public final String key;
        public final String value;

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

