/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.bookmarks.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.openide.awt.Actions;
import org.openide.cookies.EditorCookie;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ToggleBookmarkAction
extends BaseAction {
    private static final String ACTION_NAME = "bookmark-toggle";
    private static final String ACTION_ICON = "org/netbeans/modules/editor/bookmarks/resources/toggle_bookmark.png";

    public ToggleBookmarkAction() {
        super(NbBundle.getMessage(ToggleBookmarkAction.class, (String)ACTION_NAME));
        this.putValue("IconResource", ACTION_ICON);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)((String)this.getValue("Name"))));
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.updateEnabled();
        EditorRegistry.addPropertyChangeListener(evt -> this.updateEnabled());
    }

    private void updateEnabled() {
        this.setEnabled(EditorRegistry.lastFocusedComponent() != null);
    }

    public void actionPerformed(ActionEvent arg0, JTextComponent target) {
        if (target != null) {
            if (Utilities.getEditorUI((JTextComponent)target).isGlyphGutterVisible()) {
                Caret caret = target.getCaret();
                BookmarkList bookmarkList = BookmarkList.get(target.getDocument());
                bookmarkList.toggleLineBookmark(caret.getDot());
            } else {
                target.getToolkit().beep();
            }
        }
    }

    public static JTextComponent findComponent(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        return ec == null ? null : NbDocument.findRecentEditorPane((EditorCookie)ec);
    }
}

