/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.monitoring.Monitoring;
import com.oracle.bmc.monitoring.MonitoringPaginators;
import com.oracle.bmc.monitoring.MonitoringWaiters;
import com.oracle.bmc.monitoring.model.Alarm;
import com.oracle.bmc.monitoring.model.AlarmDimensionStatesCollection;
import com.oracle.bmc.monitoring.model.AlarmHistoryCollection;
import com.oracle.bmc.monitoring.model.AlarmStatusSummary;
import com.oracle.bmc.monitoring.model.AlarmSummary;
import com.oracle.bmc.monitoring.model.Metric;
import com.oracle.bmc.monitoring.model.MetricData;
import com.oracle.bmc.monitoring.model.PostMetricDataResponseDetails;
import com.oracle.bmc.monitoring.requests.ChangeAlarmCompartmentRequest;
import com.oracle.bmc.monitoring.requests.CreateAlarmRequest;
import com.oracle.bmc.monitoring.requests.DeleteAlarmRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmHistoryRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsStatusRequest;
import com.oracle.bmc.monitoring.requests.ListMetricsRequest;
import com.oracle.bmc.monitoring.requests.PostMetricDataRequest;
import com.oracle.bmc.monitoring.requests.RemoveAlarmSuppressionRequest;
import com.oracle.bmc.monitoring.requests.RetrieveDimensionStatesRequest;
import com.oracle.bmc.monitoring.requests.SummarizeMetricsDataRequest;
import com.oracle.bmc.monitoring.requests.UpdateAlarmRequest;
import com.oracle.bmc.monitoring.responses.ChangeAlarmCompartmentResponse;
import com.oracle.bmc.monitoring.responses.CreateAlarmResponse;
import com.oracle.bmc.monitoring.responses.DeleteAlarmResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmHistoryResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsStatusResponse;
import com.oracle.bmc.monitoring.responses.ListMetricsResponse;
import com.oracle.bmc.monitoring.responses.PostMetricDataResponse;
import com.oracle.bmc.monitoring.responses.RemoveAlarmSuppressionResponse;
import com.oracle.bmc.monitoring.responses.RetrieveDimensionStatesResponse;
import com.oracle.bmc.monitoring.responses.SummarizeMetricsDataResponse;
import com.oracle.bmc.monitoring.responses.UpdateAlarmResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringClient
extends BaseSyncClient
implements Monitoring {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MONITORING").serviceEndpointPrefix("telemetry").serviceEndpointTemplate("https://telemetry.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(MonitoringClient.class);
    private final MonitoringWaiters waiters;
    private final MonitoringPaginators paginators;

    MonitoringClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Monitoring-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new MonitoringWaiters(executorService, this);
        this.paginators = new MonitoringPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeAlarmCompartmentResponse changeAlarmCompartment(ChangeAlarmCompartmentRequest request) {
        Validate.notBlank((String)request.getAlarmId(), (String)"alarmId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAlarmCompartmentDetails(), "changeAlarmCompartmentDetails is required");
        return (ChangeAlarmCompartmentResponse)this.clientCall(request, ChangeAlarmCompartmentResponse::builder).logger(LOG, "changeAlarmCompartment").serviceDetails("Monitoring", "ChangeAlarmCompartment", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/Alarm/ChangeAlarmCompartment").method(Method.POST).requestBuilder(ChangeAlarmCompartmentRequest::builder).basePath("/20180401").appendPathParam("alarms").appendPathParam(request.getAlarmId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAlarmCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAlarmResponse createAlarm(CreateAlarmRequest request) {
        Objects.requireNonNull(request.getCreateAlarmDetails(), "createAlarmDetails is required");
        return (CreateAlarmResponse)this.clientCall(request, CreateAlarmResponse::builder).logger(LOG, "createAlarm").serviceDetails("Monitoring", "CreateAlarm", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/Alarm/CreateAlarm").method(Method.POST).requestBuilder(CreateAlarmRequest::builder).basePath("/20180401").appendPathParam("alarms").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Alarm.class, CreateAlarmResponse.Builder::alarm).handleResponseHeaderString("etag", CreateAlarmResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAlarmResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteAlarmResponse deleteAlarm(DeleteAlarmRequest request) {
        Validate.notBlank((String)request.getAlarmId(), (String)"alarmId must not be blank", (Object[])new Object[0]);
        return (DeleteAlarmResponse)this.clientCall(request, DeleteAlarmResponse::builder).logger(LOG, "deleteAlarm").serviceDetails("Monitoring", "DeleteAlarm", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/Alarm/DeleteAlarm").method(Method.DELETE).requestBuilder(DeleteAlarmRequest::builder).basePath("/20180401").appendPathParam("alarms").appendPathParam(request.getAlarmId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAlarmResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAlarmResponse getAlarm(GetAlarmRequest request) {
        Validate.notBlank((String)request.getAlarmId(), (String)"alarmId must not be blank", (Object[])new Object[0]);
        return (GetAlarmResponse)this.clientCall(request, GetAlarmResponse::builder).logger(LOG, "getAlarm").serviceDetails("Monitoring", "GetAlarm", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/Alarm/GetAlarm").method(Method.GET).requestBuilder(GetAlarmRequest::builder).basePath("/20180401").appendPathParam("alarms").appendPathParam(request.getAlarmId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Alarm.class, GetAlarmResponse.Builder::alarm).handleResponseHeaderString("etag", GetAlarmResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAlarmResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAlarmHistoryResponse getAlarmHistory(GetAlarmHistoryRequest request) {
        Validate.notBlank((String)request.getAlarmId(), (String)"alarmId must not be blank", (Object[])new Object[0]);
        return (GetAlarmHistoryResponse)this.clientCall(request, GetAlarmHistoryResponse::builder).logger(LOG, "getAlarmHistory").serviceDetails("Monitoring", "GetAlarmHistory", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/AlarmHistoryCollection/GetAlarmHistory").method(Method.GET).requestBuilder(GetAlarmHistoryRequest::builder).basePath("/20180401").appendPathParam("alarms").appendPathParam(request.getAlarmId()).appendPathParam("history").appendEnumQueryParam("alarmHistorytype", (BmcEnum)request.getAlarmHistorytype()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("timestampGreaterThanOrEqualTo", (Object)request.getTimestampGreaterThanOrEqualTo()).appendQueryParam("timestampLessThan", (Object)request.getTimestampLessThan()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AlarmHistoryCollection.class, GetAlarmHistoryResponse.Builder::alarmHistoryCollection).handleResponseHeaderString("opc-request-id", GetAlarmHistoryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", GetAlarmHistoryResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListAlarmsResponse listAlarms(ListAlarmsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAlarmsResponse)this.clientCall(request, ListAlarmsResponse::builder).logger(LOG, "listAlarms").serviceDetails("Monitoring", "ListAlarms", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/AlarmSummary/ListAlarms").method(Method.GET).requestBuilder(ListAlarmsRequest::builder).basePath("/20180401").appendPathParam("alarms").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AlarmSummary.class, ListAlarmsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAlarmsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAlarmsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAlarmsStatusResponse listAlarmsStatus(ListAlarmsStatusRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAlarmsStatusResponse)this.clientCall(request, ListAlarmsStatusResponse::builder).logger(LOG, "listAlarmsStatus").serviceDetails("Monitoring", "ListAlarmsStatus", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/AlarmStatusSummary/ListAlarmsStatus").method(Method.GET).requestBuilder(ListAlarmsStatusRequest::builder).basePath("/20180401").appendPathParam("alarms").appendPathParam("status").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AlarmStatusSummary.class, ListAlarmsStatusResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAlarmsStatusResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAlarmsStatusResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListMetricsResponse listMetrics(ListMetricsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getListMetricsDetails(), "listMetricsDetails is required");
        return (ListMetricsResponse)this.clientCall(request, ListMetricsResponse::builder).logger(LOG, "listMetrics").serviceDetails("Monitoring", "ListMetrics", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/Metric/ListMetrics").method(Method.POST).requestBuilder(ListMetricsRequest::builder).basePath("/20180401").appendPathParam("metrics").appendPathParam("actions").appendPathParam("listMetrics").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBodyList(Metric.class, ListMetricsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListMetricsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListMetricsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public PostMetricDataResponse postMetricData(PostMetricDataRequest request) {
        Objects.requireNonNull(request.getPostMetricDataDetails(), "postMetricDataDetails is required");
        return (PostMetricDataResponse)this.clientCall(request, PostMetricDataResponse::builder).logger(LOG, "postMetricData").serviceDetails("Monitoring", "PostMetricData", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/MetricData/PostMetricData").method(Method.POST).requestBuilder(PostMetricDataRequest::builder).basePath("/20180401").appendPathParam("metrics").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("content-encoding", request.getContentEncoding()).hasBody().handleBody(PostMetricDataResponseDetails.class, PostMetricDataResponse.Builder::postMetricDataResponseDetails).handleResponseHeaderString("opc-request-id", PostMetricDataResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveAlarmSuppressionResponse removeAlarmSuppression(RemoveAlarmSuppressionRequest request) {
        Validate.notBlank((String)request.getAlarmId(), (String)"alarmId must not be blank", (Object[])new Object[0]);
        return (RemoveAlarmSuppressionResponse)this.clientCall(request, RemoveAlarmSuppressionResponse::builder).logger(LOG, "removeAlarmSuppression").serviceDetails("Monitoring", "RemoveAlarmSuppression", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/Suppression/RemoveAlarmSuppression").method(Method.POST).requestBuilder(RemoveAlarmSuppressionRequest::builder).basePath("/20180401").appendPathParam("alarms").appendPathParam(request.getAlarmId()).appendPathParam("actions").appendPathParam("removeSuppression").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", RemoveAlarmSuppressionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RetrieveDimensionStatesResponse retrieveDimensionStates(RetrieveDimensionStatesRequest request) {
        Validate.notBlank((String)request.getAlarmId(), (String)"alarmId must not be blank", (Object[])new Object[0]);
        return (RetrieveDimensionStatesResponse)this.clientCall(request, RetrieveDimensionStatesResponse::builder).logger(LOG, "retrieveDimensionStates").serviceDetails("Monitoring", "RetrieveDimensionStates", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/AlarmDimensionStatesCollection/RetrieveDimensionStates").method(Method.POST).requestBuilder(RetrieveDimensionStatesRequest::builder).basePath("/20180401").appendPathParam("alarms").appendPathParam(request.getAlarmId()).appendPathParam("actions").appendPathParam("retrieveDimensionStates").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AlarmDimensionStatesCollection.class, RetrieveDimensionStatesResponse.Builder::alarmDimensionStatesCollection).handleResponseHeaderString("opc-request-id", RetrieveDimensionStatesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RetrieveDimensionStatesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeMetricsDataResponse summarizeMetricsData(SummarizeMetricsDataRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getSummarizeMetricsDataDetails(), "summarizeMetricsDataDetails is required");
        return (SummarizeMetricsDataResponse)this.clientCall(request, SummarizeMetricsDataResponse::builder).logger(LOG, "summarizeMetricsData").serviceDetails("Monitoring", "SummarizeMetricsData", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/MetricData/SummarizeMetricsData").method(Method.POST).requestBuilder(SummarizeMetricsDataRequest::builder).basePath("/20180401").appendPathParam("metrics").appendPathParam("actions").appendPathParam("summarizeMetricsData").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBodyList(MetricData.class, SummarizeMetricsDataResponse.Builder::items).handleResponseHeaderString("opc-request-id", SummarizeMetricsDataResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateAlarmResponse updateAlarm(UpdateAlarmRequest request) {
        Validate.notBlank((String)request.getAlarmId(), (String)"alarmId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAlarmDetails(), "updateAlarmDetails is required");
        return (UpdateAlarmResponse)this.clientCall(request, UpdateAlarmResponse::builder).logger(LOG, "updateAlarm").serviceDetails("Monitoring", "UpdateAlarm", "https://docs.oracle.com/iaas/api/#/en/monitoring/20180401/Alarm/UpdateAlarm").method(Method.PUT).requestBuilder(UpdateAlarmRequest::builder).basePath("/20180401").appendPathParam("alarms").appendPathParam(request.getAlarmId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Alarm.class, UpdateAlarmResponse.Builder::alarm).handleResponseHeaderString("etag", UpdateAlarmResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAlarmResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public MonitoringWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public MonitoringPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public MonitoringClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)MonitoringClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MonitoringClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(MonitoringClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MonitoringClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)MonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)MonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)MonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)MonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)MonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)MonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MonitoringClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "monitoring";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"monitoring");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public MonitoringClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new MonitoringClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

